<?php

namespace App\Classes;

use Illuminate\Support\Facades\DB;

class IconSetsData
{
    /**
     * Insert icon sets and icons into database
     *
     * @return void
     */
    public static function seedIconSets()
    {
        DB::table('icons')->delete();
        DB::table('icon_sets')->delete();

        DB::statement('ALTER TABLE icon_sets AUTO_INCREMENT = 1');
        DB::statement('ALTER TABLE icons AUTO_INCREMENT = 1');

        $iconSets = self::getIconSets();

        $now = now();
        $iconSetId = 1;

        foreach ($iconSets as $setData) {
            $icons = $setData['icons'];
            unset($setData['icons']);

            // Insert icon set
            DB::table('icon_sets')->insert([
                'id' => $iconSetId,
                'name' => $setData['name'],
                'prefix' => $setData['prefix'],
                'sort_order' => $setData['sort_order'],
                'is_active' => true,
                'created_at' => $now,
                'updated_at' => $now,
            ]);

            // Prepare icons for batch insertion
            $iconsData = [];
            foreach ($icons as $iconName) {
                $iconsData[] = [
                    'icon_set_id' => $iconSetId,
                    'name' => $iconName,
                    'full_name' => $setData['prefix'] . ':' . $iconName,
                    'is_active' => true,
                    'created_at' => $now,
                    'updated_at' => $now,
                ];
            }

            // Batch insert icons
            if (!empty($iconsData)) {
                foreach (array_chunk($iconsData, 1000) as $chunk) {
                    DB::table('icons')->insert($chunk);
                }
            }

            $iconSetId++;
        }
    }

    /**
     * Get icon sets data
     *
     * @return array
     */
    public static function getIconSets()
    {
        return [
            [
                'name' => 'Lucide',
                'prefix' => 'lucide',
                'sort_order' => 1,
                'icons' => [
                    // Navigation & UI
                    'home',
                    'menu',
                    'x',
                    'check',
                    'plus',
                    'minus',
                    'arrow-left',
                    'arrow-right',
                    'arrow-up',
                    'arrow-down',
                    'chevron-left',
                    'chevron-right',
                    'chevron-up',
                    'chevron-down',
                    'chevrons-left',
                    'chevrons-right',
                    'chevrons-up',
                    'chevrons-down',
                    'move',
                    'move-horizontal',
                    'move-vertical',
                    'maximize',
                    'minimize',
                    'expand',
                    'shrink',
                    'external-link',
                    'corner-up-left',
                    'corner-up-right',
                    'refresh-cw',
                    'refresh-ccw',
                    'rotate-cw',
                    'rotate-ccw',
                    'undo',
                    'redo',

                    // User & People
                    'user',
                    'users',
                    'user-plus',
                    'user-minus',
                    'user-check',
                    'user-x',
                    'user-circle',
                    'users-2',
                    'contact',
                    'contact-2',
                    'smile',
                    'frown',
                    'meh',
                    'angry',
                    'laugh',
                    'annoyed',

                    // Communication
                    'mail',
                    'mail-open',
                    'inbox',
                    'send',
                    'message-square',
                    'message-circle',
                    'messages-square',
                    'phone',
                    'phone-call',
                    'phone-incoming',
                    'phone-outgoing',
                    'phone-missed',
                    'phone-off',
                    'video',
                    'video-off',
                    'mic',
                    'mic-off',
                    'volume',
                    'volume-1',
                    'volume-2',
                    'volume-x',
                    'bell',
                    'bell-off',
                    'bell-ring',
                    'at-sign',
                    'hash',
                    'megaphone',

                    // Time & Calendar
                    'clock',
                    'clock-1',
                    'clock-2',
                    'clock-3',
                    'clock-4',
                    'clock-5',
                    'clock-6',
                    'clock-7',
                    'clock-8',
                    'clock-9',
                    'clock-10',
                    'clock-11',
                    'clock-12',
                    'calendar',
                    'calendar-days',
                    'calendar-check',
                    'calendar-plus',
                    'calendar-minus',
                    'calendar-x',
                    'calendar-clock',
                    'calendar-heart',
                    'calendar-range',
                    'timer',
                    'timer-off',
                    'hourglass',
                    'alarm-clock',
                    'alarm-clock-off',
                    'stopwatch',
                    'watch',

                    // Files & Folders
                    'file',
                    'file-text',
                    'file-plus',
                    'file-minus',
                    'file-check',
                    'file-x',
                    'file-edit',
                    'file-search',
                    'file-code',
                    'file-json',
                    'file-image',
                    'file-video',
                    'file-audio',
                    'file-archive',
                    'file-spreadsheet',
                    'folder',
                    'folder-open',
                    'folder-plus',
                    'folder-minus',
                    'folder-check',
                    'folder-x',
                    'folder-search',
                    'folders',
                    'clipboard',
                    'clipboard-check',
                    'clipboard-copy',
                    'clipboard-list',
                    'clipboard-x',
                    'clipboard-paste',

                    // Media & Images
                    'image',
                    'image-plus',
                    'image-minus',
                    'images',
                    'camera',
                    'camera-off',
                    'aperture',
                    'focus',
                    'scan',
                    'film',
                    'clapperboard',
                    'play',
                    'pause',
                    'play-circle',
                    'pause-circle',
                    'stop-circle',
                    'skip-back',
                    'skip-forward',
                    'rewind',
                    'fast-forward',
                    'repeat',
                    'shuffle',
                    'music',
                    'music-2',
                    'music-3',
                    'music-4',
                    'headphones',
                    'speaker',
                    'radio',
                    'podcast',

                    // Editing & Design
                    'pencil',
                    'pen',
                    'pen-tool',
                    'highlighter',
                    'eraser',
                    'paintbrush',
                    'palette',
                    'pipette',
                    'crop',
                    'scissors',
                    'copy',
                    'type',
                    'bold',
                    'italic',
                    'underline',
                    'strikethrough',
                    'align-left',
                    'align-center',
                    'align-right',
                    'align-justify',
                    'list',
                    'list-ordered',
                    'list-checks',
                    'heading-1',
                    'heading-2',
                    'heading-3',
                    'heading-4',
                    'quote',
                    'code',
                    'code-2',
                    'braces',
                    'brackets',
                    'terminal',

                    // Actions
                    'search',
                    'filter',
                    'sliders',
                    'settings',
                    'settings-2',
                    'wrench',
                    'tool',
                    'hammer',
                    'save',
                    'download',
                    'upload',
                    'trash',
                    'trash-2',
                    'archive',
                    'archive-restore',
                    'log-in',
                    'log-out',
                    'power',
                    'power-off',
                    'zap',
                    'zap-off',
                    'activity',
                    'target',
                    'crosshair',
                    'scan-line',

                    // E-commerce & Business
                    'shopping-cart',
                    'shopping-bag',
                    'store',
                    'receipt',
                    'credit-card',
                    'wallet',
                    'banknote',
                    'coins',
                    'dollar-sign',
                    'euro',
                    'pound-sterling',
                    'bitcoin',
                    'percent',
                    'badge',
                    'badge-check',
                    'badge-x',
                    'badge-plus',
                    'badge-minus',
                    'badge-dollar-sign',
                    'badge-percent',
                    'tag',
                    'tags',
                    'ticket',
                    'gift',
                    'package',
                    'package-check',
                    'package-x',
                    'box',
                    'boxes',
                    'truck',
                    'car',
                    'plane',
                    'ship',
                    'train',
                    'bus',
                    'bike',

                    // Charts & Data
                    'bar-chart',
                    'bar-chart-2',
                    'bar-chart-3',
                    'bar-chart-4',
                    'bar-chart-horizontal',
                    'line-chart',
                    'pie-chart',
                    'trending-up',
                    'trending-down',
                    'gauge',
                    'gantt-chart',
                    'git-branch',
                    'git-commit',
                    'git-merge',
                    'git-pull-request',
                    'git-fork',

                    // Security & Privacy
                    'lock',
                    'unlock',
                    'key',
                    'key-round',
                    'shield',
                    'shield-check',
                    'shield-alert',
                    'shield-x',
                    'shield-off',
                    'shield-plus',
                    'fingerprint',
                    'eye',
                    'eye-off',
                    'scan-eye',
                    'verified',

                    // Status & Alerts
                    'check-circle',
                    'check-square',
                    'x-circle',
                    'x-square',
                    'alert-triangle',
                    'alert-circle',
                    'alert-octagon',
                    'info',
                    'help-circle',
                    'circle-help',
                    'message-circle-warning',
                    'ban',
                    'octagon',
                    'triangle',

                    // Nature & Weather
                    'sun',
                    'moon',
                    'cloud',
                    'cloud-rain',
                    'cloud-snow',
                    'cloud-lightning',
                    'cloud-drizzle',
                    'cloud-fog',
                    'cloud-hail',
                    'cloud-sun',
                    'cloud-moon',
                    'wind',
                    'thermometer',
                    'thermometer-sun',
                    'thermometer-snowflake',
                    'umbrella',
                    'snowflake',
                    'droplet',
                    'droplets',
                    'waves',
                    'leaf',
                    'tree-deciduous',
                    'tree-pine',
                    'trees',
                    'flower',
                    'flower-2',
                    'sprout',
                    'mountain',
                    'mountain-snow',
                    'sunrise',
                    'sunset',
                    'star',
                    'sparkle',
                    'sparkles',

                    // Buildings & Places
                    'building',
                    'building-2',
                    'house',
                    'hotel',
                    'warehouse',
                    'factory',
                    'hospital',
                    'school',
                    'church',
                    'castle',
                    'landmark',
                    'map',
                    'map-pin',
                    'map-pinned',
                    'navigation',
                    'navigation-2',
                    'compass',
                    'globe-2',
                    'earth',
                    'locate',
                    'locate-fixed',
                    'locate-off',

                    // Technology & Devices
                    'smartphone',
                    'tablet',
                    'laptop',
                    'monitor',
                    'tv',
                    'projector',
                    'cpu',
                    'hard-drive',
                    'database',
                    'server',
                    'wifi',
                    'wifi-off',
                    'bluetooth',
                    'bluetooth-off',
                    'signal',
                    'signal-low',
                    'signal-medium',
                    'signal-high',
                    'battery',
                    'battery-charging',
                    'battery-full',
                    'battery-low',
                    'battery-medium',
                    'battery-warning',
                    'plug',
                    'plug-zap',
                    'usb',
                    'mouse',
                    'keyboard',
                    'printer',
                    'scanner',
                    'qr-code',
                    'nfc',
                    'cast',
                    'airplay',
                    'router',
                    'cable',
                    'bot',
                    'brain',
                    'circuit-board',

                    // Objects & Tools
                    'lightbulb',
                    'lamp',
                    'lamp-desk',
                    'lamp-floor',
                    'flashlight',
                    'glasses',
                    'binoculars',
                    'telescope',
                    'microscope',
                    'magnet',
                    'ruler',
                    'scale',
                    'calculator',
                    'flask-conical',
                    'flask-round',
                    'beaker',
                    'syringe',
                    'pill',
                    'stethoscope',
                    'heart-pulse',
                    'dna',
                    'bone',
                    'award',
                    'medal',
                    'crown',
                    'gem',
                    'diamond',
                    'ring',
                    'briefcase',
                    'suitcase',

                    // Symbols & Shapes
                    'heart',
                    'heart-off',
                    'heart-crack',
                    'heart-handshake',
                    'flag',
                    'flag-off',
                    'flag-triangle-left',
                    'flag-triangle-right',
                    'circle',
                    'square',
                    'hexagon',
                    'pentagon',
                    'star-off',
                    'star-half',
                    'infinity',
                    'link',
                    'link-2',
                    'unlink',
                    'unlink-2',
                    'paperclip',
                    'pin',
                    'pin-off',

                    // Food & Drinks
                    'coffee',
                    'cup-soda',
                    'beer',
                    'wine',
                    'martini',
                    'milk',
                    'apple',
                    'banana',
                    'cherry',
                    'grape',
                    'citrus',
                    'carrot',
                    'salad',
                    'pizza',
                    'sandwich',
                    'cookie',
                    'cake',
                    'ice-cream',
                    'ice-cream-2',
                    'popcorn',
                    'egg',
                    'egg-fried',
                    'beef',
                    'utensils',
                    'utensils-crossed',
                    'chef-hat',

                    // Sports & Games
                    'dumbbell',
                    'basketball',
                    'volleyball',
                    'football',
                    'soccer',
                    'tennis',
                    'baseball',
                    'dice-1',
                    'dice-2',
                    'dice-3',
                    'dice-4',
                    'dice-5',
                    'dice-6',
                    'gamepad',
                    'gamepad-2',
                    'joystick',
                    'puzzle',
                    'swords',

                    // Social & Reactions
                    'thumbs-up',
                    'thumbs-down',
                    'hand',
                    'hand-metal',
                    'grip-horizontal',
                    'grip-vertical',
                    'grab',
                    'pointer',
                    'mouse-pointer',
                    'mouse-pointer-2',

                    // Tables & Grids
                    'table',
                    'table-2',
                    'grid',
                    'grid-2x2',
                    'grid-3x3',
                    'layout-grid',
                    'layout-dashboard',
                    'layout-list',
                    'layout-template',
                    'kanban',

                    // Miscellaneous
                    'rocket',
                    'satellite',
                    'atom',
                    'book',
                    'book-open',
                    'newspaper',
                    'rss',
                    'languages',
                    'translate',
                    'accessibility',
                    'baby',
                    'cat',
                    'dog',
                    'bird',
                    'bug',
                    'rabbit',
                    'squirrel',
                    'paw-print',
                    'footprints',
                ],
            ],
            [
                'name' => 'Heroicons',
                'prefix' => 'heroicons',
                'sort_order' => 2,
                'icons' => [
                    'home',
                    'user',
                    'cog-6-tooth',
                    'bell',
                    'envelope',
                    'calendar',
                    'folder',
                    'document',
                    'photo',
                    'camera',
                    'video-camera',
                    'microphone',
                    'phone',
                    'chat-bubble-left',
                    'heart',
                    'star',
                    'bookmark',
                    'flag',
                    'map-pin',
                    'globe-alt',
                    'building-office',
                    'shopping-cart',
                    'credit-card',
                    'currency-dollar',
                    'chart-bar',
                    'presentation-chart-line',
                    'clipboard-document',
                    'pencil',
                    'trash',
                    'archive-box',
                    'arrow-down-tray',
                    'arrow-up-tray',
                    'magnifying-glass',
                    'funnel',
                    'adjustments-horizontal',
                    'bars-3',
                    'x-mark',
                    'check',
                    'plus',
                    'minus',
                    'arrow-left',
                    'arrow-right',
                    'arrow-up',
                    'arrow-down',
                    'chevron-left',
                    'chevron-right',
                    'chevron-up',
                    'chevron-down',
                    'eye',
                    'eye-slash',
                    'lock-closed',
                    'lock-open',
                    'key',
                    'shield-check',
                    'exclamation-triangle',
                    'information-circle',
                    'question-mark-circle',
                    'check-circle',
                    'x-circle',
                    'clock',
                    'calendar-days',
                    'users',
                    'user-plus',
                    'user-minus',
                    'user-group',
                    'identification',
                    'academic-cap',
                    'beaker',
                    'bolt',
                    'bug-ant',
                    'cake',
                    'calculator',
                    'chart-pie',
                    'cloud',
                    'code-bracket',
                    'command-line',
                    'computer-desktop',
                    'cpu-chip',
                    'cube',
                    'device-phone-mobile',
                    'device-tablet',
                    'face-smile',
                    'face-frown',
                    'film',
                    'fire',
                    'gift',
                    'hand-thumb-up',
                    'hand-thumb-down',
                    'hashtag',
                    'inbox',
                    'language',
                    'light-bulb',
                    'link',
                    'list-bullet',
                    'map',
                    'megaphone',
                    'moon',
                    'musical-note',
                    'newspaper',
                    'paint-brush',
                    'paper-airplane',
                    'paper-clip',
                    'pencil-square',
                    'play',
                    'pause',
                    'power',
                    'printer',
                    'puzzle-piece',
                    'qr-code',
                    'receipt-percent',
                    'rocket-launch',
                    'rss',
                    'scale',
                    'scissors',
                    'server',
                    'share',
                    'signal',
                    'sparkles',
                    'speaker-wave',
                    'sun',
                    'swatch',
                    'table-cells',
                    'tag',
                    'ticket',
                    'truck',
                    'tv',
                    'wifi',
                    'wrench',
                    'wrench-screwdriver',
                ],
            ],
            [
                'name' => 'Material Design Icons',
                'prefix' => 'mdi',
                'sort_order' => 3,
                'icons' => [
                    'home',
                    'account',
                    'cog',
                    'bell',
                    'email',
                    'calendar',
                    'folder',
                    'file',
                    'image',
                    'camera',
                    'video',
                    'microphone',
                    'phone',
                    'message',
                    'heart',
                    'star',
                    'bookmark',
                    'flag',
                    'map-marker',
                    'earth',
                    'office-building',
                    'cart',
                    'credit-card',
                    'currency-usd',
                    'chart-bar',
                    'chart-line',
                    'clipboard',
                    'pencil',
                    'delete',
                    'archive',
                    'download',
                    'upload',
                    'magnify',
                    'filter',
                    'tune',
                    'menu',
                    'close',
                    'check',
                    'plus',
                    'minus',
                    'arrow-left',
                    'arrow-right',
                    'arrow-up',
                    'arrow-down',
                    'chevron-left',
                    'chevron-right',
                    'chevron-up',
                    'chevron-down',
                    'eye',
                    'eye-off',
                    'lock',
                    'lock-open',
                    'key',
                    'shield-check',
                    'alert',
                    'information',
                    'help-circle',
                    'check-circle',
                    'close-circle',
                    'clock',
                    'calendar-month',
                    'account-group',
                    'account-plus',
                    'account-minus',
                    'account-multiple',
                    'card-account-details',
                    'school',
                    'flask',
                    'lightning-bolt',
                    'bug',
                    'cake',
                    'calculator',
                    'chart-pie',
                    'cloud',
                    'code-tags',
                    'console',
                    'desktop-mac',
                    'memory',
                    'cube',
                    'cellphone',
                    'tablet',
                    'emoticon-happy',
                    'emoticon-sad',
                    'filmstrip',
                    'fire',
                    'gift',
                    'thumb-up',
                    'thumb-down',
                    'pound',
                    'inbox',
                    'translate',
                    'lightbulb',
                    'link',
                    'format-list-bulleted',
                    'map',
                    'bullhorn',
                    'weather-night',
                    'music',
                    'newspaper',
                    'brush',
                    'send',
                    'paperclip',
                    'square-edit-outline',
                    'play',
                    'pause',
                    'power',
                    'printer',
                    'puzzle',
                    'qrcode',
                    'percent',
                    'rocket',
                    'rss',
                    'scale-balance',
                    'content-cut',
                    'server',
                    'share',
                    'signal',
                    'shimmer',
                    'volume-high',
                    'white-balance-sunny',
                    'palette',
                    'table',
                    'tag',
                    'ticket',
                    'truck',
                    'television',
                    'wifi',
                    'wrench',
                    'tools',
                ],
            ],
            [
                'name' => 'Tabler Icons',
                'prefix' => 'tabler',
                'sort_order' => 4,
                'icons' => [
                    'home',
                    'user',
                    'settings',
                    'bell',
                    'mail',
                    'calendar',
                    'folder',
                    'file',
                    'photo',
                    'camera',
                    'video',
                    'microphone',
                    'phone',
                    'message',
                    'heart',
                    'star',
                    'bookmark',
                    'flag',
                    'map-pin',
                    'world',
                    'building',
                    'shopping-cart',
                    'credit-card',
                    'currency-dollar',
                    'chart-bar',
                    'chart-line',
                    'clipboard',
                    'pencil',
                    'trash',
                    'archive',
                    'download',
                    'upload',
                    'search',
                    'filter',
                    'adjustments',
                    'menu-2',
                    'x',
                    'check',
                    'plus',
                    'minus',
                    'arrow-left',
                    'arrow-right',
                    'arrow-up',
                    'arrow-down',
                    'chevron-left',
                    'chevron-right',
                    'chevron-up',
                    'chevron-down',
                    'eye',
                    'eye-off',
                    'lock',
                    'lock-open',
                    'key',
                    'shield-check',
                    'alert-triangle',
                    'info-circle',
                    'help',
                    'circle-check',
                    'circle-x',
                    'clock',
                    'calendar-event',
                    'users',
                    'user-plus',
                    'user-minus',
                    'users-group',
                    'id',
                    'school',
                    'flask',
                    'bolt',
                    'bug',
                    'cake',
                    'calculator',
                    'chart-pie',
                    'cloud',
                    'code',
                    'terminal',
                    'device-desktop',
                    'cpu',
                    'box',
                    'device-mobile',
                    'device-tablet',
                    'mood-smile',
                    'mood-sad',
                    'movie',
                    'flame',
                    'gift',
                    'thumb-up',
                    'thumb-down',
                    'hash',
                    'inbox',
                    'language',
                    'bulb',
                    'link',
                    'list',
                    'map',
                    'speakerphone',
                    'moon',
                    'music',
                    'news',
                    'brush',
                    'send',
                    'paperclip',
                    'edit',
                    'player-play',
                    'player-pause',
                    'power',
                    'printer',
                    'puzzle',
                    'qrcode',
                    'discount',
                    'rocket',
                    'rss',
                    'scale',
                    'cut',
                    'server',
                    'share',
                    'signal',
                    'sparkles',
                    'volume',
                    'sun',
                    'palette',
                    'table',
                    'tag',
                    'ticket',
                    'truck',
                    'device-tv',
                    'wifi',
                    'tool',
                ],
            ],
            [
                'name' => 'Phosphor',
                'prefix' => 'ph',
                'sort_order' => 5,
                'icons' => [
                    'house',
                    'user',
                    'gear',
                    'bell',
                    'envelope',
                    'calendar',
                    'folder',
                    'file',
                    'image',
                    'camera',
                    'video-camera',
                    'microphone',
                    'phone',
                    'chat',
                    'heart',
                    'star',
                    'bookmark-simple',
                    'flag',
                    'map-pin',
                    'globe',
                    'buildings',
                    'shopping-cart',
                    'credit-card',
                    'currency-dollar',
                    'chart-bar',
                    'chart-line',
                    'clipboard',
                    'pencil',
                    'trash',
                    'archive',
                    'download',
                    'upload',
                    'magnifying-glass',
                    'funnel',
                    'sliders',
                    'list',
                    'x',
                    'check',
                    'plus',
                    'minus',
                    'arrow-left',
                    'arrow-right',
                    'arrow-up',
                    'arrow-down',
                    'caret-left',
                    'caret-right',
                    'caret-up',
                    'caret-down',
                    'eye',
                    'eye-slash',
                    'lock',
                    'lock-open',
                    'key',
                    'shield-check',
                    'warning',
                    'info',
                    'question',
                    'check-circle',
                    'x-circle',
                    'clock',
                    'calendar-blank',
                    'users',
                    'user-plus',
                    'user-minus',
                    'users-three',
                    'identification-card',
                    'student',
                    'flask',
                    'lightning',
                    'bug',
                    'cake',
                    'calculator',
                    'chart-pie',
                    'cloud',
                    'code',
                    'terminal',
                    'desktop',
                    'cpu',
                    'cube',
                    'device-mobile',
                    'device-tablet',
                    'smiley',
                    'smiley-sad',
                    'film-strip',
                    'fire',
                    'gift',
                    'thumbs-up',
                    'thumbs-down',
                    'hash',
                    'tray',
                    'translate',
                    'lightbulb',
                    'link',
                    'list-bullets',
                    'map-trifold',
                    'megaphone',
                    'moon',
                    'music-note',
                    'newspaper',
                    'paint-brush',
                    'paper-plane-tilt',
                    'paperclip',
                    'pencil-simple',
                    'play',
                    'pause',
                    'power',
                    'printer',
                    'puzzle-piece',
                    'qr-code',
                    'percent',
                    'rocket',
                    'rss',
                    'scales',
                    'scissors',
                    'hard-drives',
                    'share',
                    'wifi-high',
                    'sparkle',
                    'speaker-high',
                    'sun',
                    'palette',
                    'table',
                    'tag',
                    'ticket',
                    'truck',
                    'television',
                    'wifi-high',
                    'wrench',
                ],
            ],
            [
                'name' => 'Simple Icons (Brands)',
                'prefix' => 'simple-icons',
                'sort_order' => 6,
                'icons' => [
                    // Social Media
                    'facebook',
                    'twitter',
                    'x',
                    'instagram',
                    'linkedin',
                    'youtube',
                    'tiktok',
                    'snapchat',
                    'pinterest',
                    'reddit',
                    'tumblr',
                    'whatsapp',
                    'telegram',
                    'discord',
                    'slack',
                    'skype',
                    'zoom',
                    'wechat',
                    'line',
                    'viber',
                    'signal',
                    'threads',
                    'mastodon',
                    'bluesky',
                    // Professional
                    'github',
                    'gitlab',
                    'bitbucket',
                    'stackoverflow',
                    'medium',
                    'dev-dot-to',
                    'dribbble',
                    'behance',
                    'figma',
                    'adobe',
                    'sketch',
                    'invision',
                    // Music & Entertainment
                    'spotify',
                    'apple',
                    'soundcloud',
                    'bandcamp',
                    'twitch',
                    'vimeo',
                    // Business
                    'google',
                    'microsoft',
                    'amazon',
                    'apple',
                    'meta',
                    'netflix',
                    // E-commerce
                    'shopify',
                    'woocommerce',
                    'stripe',
                    'paypal',
                    'visa',
                    'mastercard',
                    // Other
                    'wordpress',
                    'drupal',
                    'joomla',
                    'ghost',
                    'substack',
                    'patreon',
                    'kofi',
                    'buymeacoffee',
                    'gofundme',
                    'kickstarter',
                ],
            ],
            [
                'name' => 'MDI Social (Brands)',
                'prefix' => 'mdi-social',
                'sort_order' => 7,
                'icons' => [
                    // Social Media (mdi format)
                    'facebook',
                    'twitter',
                    'instagram',
                    'linkedin',
                    'youtube',
                    'tiktok',
                    'snapchat',
                    'pinterest',
                    'reddit',
                    'tumblr',
                    'whatsapp',
                    'telegram',
                    'discord',
                    'slack',
                    'skype',
                    'wechat',
                    // Professional
                    'github',
                    'gitlab',
                    'stackoverflow',
                    'dev-to',
                    'medium',
                    'dribbble',
                    'behance',
                    // Music & Entertainment
                    'spotify',
                    'apple',
                    'soundcloud',
                    'twitch',
                    'vimeo',
                    // Business
                    'google',
                    'microsoft',
                    'amazon',
                    'netflix',
                    // E-commerce
                    'shopify',
                    'etsy',
                    'ebay',
                    // Other
                    'wordpress',
                    'drupal',
                    'patreon',
                ],
            ],
        ];
    }
}
