<?php

namespace App\Classes;

use App\Models\Lang;
use App\Models\Translation;
use League\CommonMark\Reference\Reference;
use Illuminate\Support\Facades\File;
use ReflectionClass;
use App\Classes\ModuleAssets;

class LangTrans
{
    public static $mainTranslations = [
        'common' => [
            'enabled' => 'Enabled',
            'disabled' => 'Disabled',
            'buy_now' => 'Buy Now',
            'working' => 'Working',
            'not_working' => 'Not Working',
            'id' => 'Id',
            'action' => 'Action',
            'placeholder_default_text' => 'Please Enter {0}',
            'placeholder_social_text' => 'Please Enter {0} Url',
            'placeholder_search_text' => 'Search By {0}',
            'select_default_text' => 'Select {0}...',
            'create' => 'Create',
            'edit' => 'Edit',
            'update' => 'Update',
            'updated' => 'Updated',
            'cancel' => 'Cancel',
            'delete' => 'Delete',
            'success' => 'Success',
            'error' => 'Error',
            'warning' => 'Warning',
            'yes' => 'Yes',
            'no' => 'No',
            'fix_errors' => 'Please Fix Below Errors.',
            'cancelled' => 'Cancelled',
            'pending' => 'Pending',
            'paid' => 'Paid',
            'completed' => 'Completed',
            'save' => 'Save',
            'all' => 'All',
            'name' => 'Name',
            'back' => 'Back',
            'max_amount' => 'Max. Amount',
            'date_time' => 'Date Time',
            'select_time' => 'Select Time',
            'start_date' => 'Start Date',
            'end_date' => 'End Date',
            'search' => 'Search',
            'date' => 'Date',
            'confirm' => 'Confirm',
            'title' => 'Title',
            'value' => 'Value',
            'add' => 'Add',
            'view' => 'View',
            'edit' => 'Edit',
            'download' => 'Download',
            'total' => 'Total',
            'email' => 'Email',
            'phone' => 'Phone',
            'purchase_code' => 'Purchase Code',
            'verify_purchase' => 'Verify Purchase',
            'install' => 'Install',
            'installing' => 'Installing',
            'updating' => 'Updating',
            'free' => 'Free',
            'paid' => 'Paid',
            'domain' => 'Domain',
            'verify' => 'Verify',
            'send' => 'Send',
            'upload' => 'Upload',
            'view_all' => 'View All',
            'unpaid' => 'Unpaid',
            'loading' => 'Loading',
            'update_app' => 'Update App',
            'welcome_back' => 'Welcome {0}',
            'off' => 'Off',
            'on_create' => 'On Create',
            'on_update' => 'On Update',
            'on_delete' => 'On Delete',
            'demo_account_credentials' => 'Demo account login credentials',
            'created_by' => 'Created By',
            'import' => 'Import',
            'file' => 'File',
            'copy_url' => 'Copy Url',
            'print' => 'Print',
            'amount' => 'Amount',
            'status' => 'Status',
            'active' => 'Active',
            'inactive' => 'Inactive',
            'verified' => 'Verified',
            'configure' => 'Configure',
            'logo' => 'Logo',
            'slug' => 'Slug',
            'description' => 'Description',
            'image' => 'Image',
            'address' => 'Address',
            'not_allowed' => 'Not Allowed',
            'details' => 'Details',
            'pending' => 'Pending',
            'approved' => 'Approved',
            'rejected' => 'Rejected',
            'skip' => 'Skip',
            'done' => 'Done',
            'next' => 'Next',
            'something_went_wrong' => 'Something went wrong',
            'px' => 'px',
            'mm' => 'mm',
            'website_switched' => 'Switched to {0}',
            'website' => 'Website',
            'select_website' => 'Select Website',
            'select_language' => 'Select Language',
            'export' => 'Export',
            'excel' => 'Excel',
            'csv' => 'CSV',
            'pdf' => 'PDF',
            'select' => 'Select',
            'select_all' => 'Select All',
            'required_message' => '{0} is required',
            'refresh' => 'Refresh',
            'selected' => 'Selected',
            'no_data' => 'No data available',
            'fetch_error' => 'Failed to load data',
            'of' => 'of',
            'items' => 'items',
            'click_or_drag_file' => 'Click or drag file to this area to upload',
            'whatsapp_number' => 'WhatsApp Number',
            'optional' => 'Optional',
            'creating' => 'Creating...',
            'saving' => 'Saving...',
            'default' => 'Default',
            'max_file_size' => 'Max File Size',
            'recommended' => 'Recommended',
            'not_set' => 'Not Set',
        ],
        'menu' => [
            'dashboard' => 'Dashboard',
            'staff_members' => 'Staff Members',
            'settings' => 'Settings',
            'company' => 'Company Settings',
            'profile' => 'Profile',
            'translations' => 'Translations',
            'languages' => 'Languages',
            'roles' => 'Role & Permissions',
            'currencies' => 'Currencies',
            'login' => 'Login',
            'logout' => 'Logout',
            'verify_product' => 'Verify Product',
            'modules' => 'Modules',
            'storage_settings' => 'Storage Settings',
            'email_settings' => 'Email Settings',
            'ai_settings' => 'AI Settings',
            'update_app' => 'Update App',
            'manual_update_app' => 'Manual Update App',
            'database_backup' => 'Database Backup',
            'pdf_fonts' => 'PDF Fonts',
            'reports' => 'Reports',
            'email_templates' => 'Email Templates',
        ],
        'dashboard' => [
            'dashboard' => 'Dashboard',
            // Period filters
            'today' => 'Today',
            'this_month' => 'This Month',
            // Stat cards
            'total_websites' => 'Total Websites',
            'total_categories' => 'Total Categories',
            'total_sections' => 'Total Sections',
            'total_languages' => 'Total Languages',
            'unique' => 'Unique',
            'enabled' => 'Enabled',
            // Business card
            'pages' => 'Pages',
            'sections' => 'Sections',
            'legal_pages' => 'Legal Pages',
            'primary' => 'Primary',
            // Lists
            'recent_websites' => 'Recent Websites',
            'website_pages' => 'Website Pages',
            'sort_order' => 'Sort Order',
            // Empty states
            'no_data' => 'No data available',
            'no_websites' => 'No websites yet',
            'no_pages' => 'No pages yet',
            'no_legal_pages' => 'No legal pages yet',
            'select_website_first' => 'Please select a website first',
            // Error messages
            'fetch_error' => 'Failed to load dashboard data',
        ],
        'role' => [
            'add' => 'Add New Role',
            'edit' => 'Edit Role',
            'created' => 'Role Created Successfully',
            'updated' => 'Role Updated Successfully',
            'deleted' => 'Role Deleted Successfully',
            'role_details' => 'Role Details',
            'delete_message' => 'Are you sure you want to delete this role?',
            'selected_delete_message' => 'Are you sure you want to delete selected role?',
            'display_name' => 'Display Name',
            'role_name' => 'Role Name',
            'description' => 'Description',
            'user_management' => 'User Management',
            'permissions' => 'Permissions',
            'search_permissions' => 'Search Permissions',
            'fetch_roles_failed' => 'Failed to fetch roles.',
            'seed_permissions_success' => 'Permissions seeded successfully!',
            'seed_permissions_failed' => 'Failed to seed permissions. Please try again.',
            'permission_added' => 'Permission "{permission}" added to role "{role}"',
            'permission_removed' => 'Permission "{permission}" removed from role "{role}"',
            'toggle_permission_failed' => 'Failed to toggle permission. Please try again.',
            'all_permissions_updated' => 'All permissions {action} role "{role}"',
            'toggle_permissions_failed' => 'Failed to toggle permissions. Please try again.',
            'expand_all_roles' => 'Expand All Roles',
            'collapse_all_roles' => 'Collapse All Roles',
            'all_selected' => 'All Selected',
            'none_selected' => 'None Selected',
            'admin_has_all_permissions' => 'Admin has all the permissions by default.',
            'seed_permissions' => 'Seed Permissions',
            'select_module' => 'Select Module',
            'assign_role' => 'Assign Role',
        ],
        'company' => [
            'add' => 'Add New Company',
            'edit' => 'Edit Company',
            'created' => 'Company Created Successfully',
            'updated' => 'Company Updated Successfully',
            'deleted' => 'Company Deleted Successfully',
            'currency_details' => 'Company Details',
            'delete_message' => 'Are you sure you want to delete this company?',
            'selected_delete_message' => 'Are you sure you want to delete selected company?',
            'name' => 'Company Name',
            'short_name' => 'Company Short Name',
            'email' => 'Company Email',
            'phone' => 'Company Phone',
            'address' => 'Company Address',
            'currency' => 'Currency',
            'logo' => 'Company Logo',
            'left_sidebar_theme' => 'Left Sidebar Theme',
            'dark' => 'Dark',
            'light' => 'Light',
            'dark_logo' => 'Dark Logo',
            'light_logo' => 'Light Logo',
            'small_dark_logo' => 'Small Dark Logo',
            'small_light_logo' => 'Small Light Logo',
            'primary_color' => 'Primary Color',
            'default_timezone' => 'Default Timezone',
            'date_format' => 'Date Format',
            'time_format' => 'Time Format',
            'auto_detect_timezone' => 'Auto Detect Timezone',
            'app_debug' => 'App Debug',
            'update_app_notification' => 'Update App Notitication',
            'login_image' => 'Login Image',
            'default_language' => 'Default Language',
            'shortcut_menu_Placement' => 'Add Menu Placement',
            'top_and_bottom' => 'Top & Bottom',
            'top_header' => 'Top Header',
            'bottom_corner' => 'Bottom Conrer',
            'shortcut_menu_setting' => 'Add Menu Settings',
            'menu_setting_updated' => 'Menu Setting Updated',
            'basic_details' => 'Basic Details',
            'details' => 'Details',
            'register_date' => 'Register Date',
            'total_users' => 'Total Users',
            'general_settings' => 'General Settings',
            'appearance' => 'Appearance',
            'preferences' => 'Preferences',
            'localization' => 'Localization',
            'advanced' => 'Advanced',
            'website_settings' => 'Website Settings',
            'website_route_prefix' => 'Website Route Prefix',
            'website_route_prefix_help' => 'This prefix will be used in the URL for website landing pages. e.g., /w/website-slug',
        ],
        'currency' => [
            'add' => 'Add New Currency',
            'edit' => 'Edit Currency',
            'created' => 'Currency Created Successfully',
            'updated' => 'Currency Updated Successfully',
            'deleted' => 'Currency Deleted Successfully',
            'currency_details' => 'Currency Details',
            'delete_message' => 'Are you sure you want to delete this currency?',
            'selected_delete_message' => 'Are you sure you want to delete selected currency?',
            'name' => 'Currency Name',
            'symbol' => 'Currency Symbol',
            'position' => 'Currency Position',
            'front' => 'Front',
            'front_position_example' => 'Example : $100',
            'behind' => 'Behind',
            'behind_position_example' => 'Example : 100$',
            'code' => 'Currency Code',
        ],
        'module' => [
            'name' => 'Module Name',
            'verified' => 'Verified',
            'verify_purchase_code' => 'Verify Purchase Code',
            'current_version' => 'Current Version',
            'latest_version' => 'Latest Version',
            'current' => 'Current',
            'latest' => 'Latest',
            'status' => 'Status',
            'module_status' => 'Module Status',
            'installed_modules' => 'Installed Modules',
            'other_modules' => 'Other Modules',
            'total_modules' => 'Total Modules',
            'all_modules' => 'All Modules',
            'ready_to_install' => 'Ready to Install',
            'available_to_install' => 'Available to Install',
            'updates_available' => 'Updates Available',
            'grid_view' => 'Grid View',
            'list_view' => 'List View',
            'verification' => 'Verification',
            'module_status_updated' => 'Modules Status Updated',
            'downloading_completed' => 'Download Completed',
            'extract_zip_file' => 'Extract Zip File',
            'file_extracted' => 'Zip File Extracted',
            'automatic_installation' => 'Automatic Installation',
            'manual_installation' => 'Manual Installation',
            'manual_upload_instructions' => 'Manual Module Upload Instructions',
            'download_module_package' => 'Download the module package (.zip file) from your purchase location or official source',
            'ensure_zip_not_corrupted' => 'Ensure the ZIP file is not corrupted and is a valid module package for this application',
            'max_file_size_allowed' => 'Maximum file size allowed is 200MB. Contact support if your module file is larger',
            'auto_extract_install' => 'After uploading, click on Install button from uploaded file. It will auto extract the zip and install the module. Please do not close this page during installation',
            'manual_upload' => 'Manual Module Upload',
            'click_or_drag_file' => 'Click or drag file to this area to upload',
            'support_single_zip' => 'Support for a single module ZIP file upload only',
            'maximum_file_size' => 'Maximum file size: 100MB',
            'uploading' => 'Uploading...',
            'upload' => 'Upload',
            'clear' => 'Clear',
            'uploaded_files' => 'Uploaded Module Files',
            'file_name' => 'File Name',
            'size' => 'Size',
            'uploaded_at' => 'Uploaded At',
            'install' => 'Install',
            'delete' => 'Delete',
            'delete_file_confirm' => 'Are you sure you want to delete this module file?',
            'install_module_confirmation' => 'Install Module - Confirmation Required',
            'install_confirm_message' => 'Are you sure you want to install this module from {0}?',
            'this_will' => 'This will:',
            'extract_to_modules' => 'Extract the ZIP file to the Modules folder',
            'run_migrations' => 'Run database migrations for the module',
            'seed_translations' => 'Seed module translations',
            'enable_module' => 'Enable the module automatically',
            'ensure_backup' => 'Please ensure you have a backup before proceeding!',
            'yes_install_now' => 'Yes, Install Now',
            'cancel' => 'Cancel',
            'file_uploaded_successfully' => 'Module file uploaded successfully!',
            'upload_failed' => 'Upload failed. Please try again.',
            'file_deleted_successfully' => 'Module file deleted successfully!',
            'failed_to_delete_file' => 'Failed to delete module file. Please try again.',
            'module_installed_successfully' => 'Module installed successfully! Module has been installed and enabled.',
            'installation_failed' => 'Module Installation Failed',
            'failed_to_install_module' => 'Failed to install module. Please try again or check the logs.',
            'only_zip_files_allowed' => 'Only ZIP files are allowed!',
            'file_size_must_be_less_than_200mb' => 'File size must be less than 200MB!',
            'preparing_installation' => 'Preparing installation...',
            'installing_module' => 'Installing Module',
            'status_updated' => 'Status Updated',
            'reloading_message' => 'Module status has been updated successfully. The page will reload automatically to apply the changes.',
            'reloading_page' => 'Reloading page in {0} seconds...',
            'reload_now' => 'Reload Now',
        ],
        'update_app' => [
            'app_details' => 'App Details',
            'name' => 'Name',
            'value' => 'Value',
            'php_version' => 'PHP Version',
            'app_version' => 'App Version',
            'laravel_version' => 'Laravel Version',
            'mysql_version' => 'MySQL Version',
            'vue_version' => 'Vue Version',
            'update_app' => 'Update App',
            'update_now' => 'Update Now',
            'update_available' => 'Update Available',
            'verify_again' => 'Verify Again',
            'verify_failed' => 'Verification Failed',
            'verify_failed_message' => 'Your application is not registerd with us. Please verify it',
            'verified_with_other_domain' => 'Your purchase code is registerd with other doamin. Please verfiy your purhcase code',
        ],
        'manual_update_app' => [
            'manual_upload_instructions' => 'Manual Upload Instructions',
            'download_latest_package' => 'Download the latest application update package (.zip file) from your purchase location or official source',
            'ensure_zip_not_corrupted' => 'Ensure the ZIP file is not corrupted and is a valid update package for this application',
            'max_file_size_allowed' => 'Maximum file size allowed is 100MB. Contact support if your update file is larger',
            'auto_extract_install' => 'After uploading, click on Install button from uploaded file. It will auto extract the zip and update the app. Please do not close this page during installation',
            'manual_upload' => 'Manual Upload',
            'click_or_drag_file' => 'Click or drag file to this area to upload',
            'support_single_zip' => 'Support for a single ZIP file upload only',
            'maximum_file_size' => 'Maximum file size: 200MB',
            'uploading_installing' => 'Uploading & Installing...',
            'upload' => 'Upload',
            'clear' => 'Clear',
            'uploaded_files' => 'Uploaded Files',
            'file_name' => 'File Name',
            'size' => 'Size',
            'uploaded_at' => 'Uploaded At',
            'install' => 'Install',
            'delete' => 'Delete',
            'delete_file_confirm' => 'Are you sure you want to delete this file?',
            'install_update_confirmation' => 'Install Update - Confirmation Required',
            'install_confirm_message' => 'Are you sure you want to install this update from {0}?',
            'this_will' => 'This will:',
            'extract_to_root' => 'Extract the ZIP file to the root application folder',
            'overwrite_existing_files' => 'Overwrite existing files',
            'run_database_migrations' => 'Run database migrations',
            'clear_all_caches' => 'Clear all caches',
            'ensure_backup' => 'Please ensure you have a backup before proceeding!',
            'yes_install_now' => 'Yes, Install Now',
            'cancel' => 'Cancel',
            'file_uploaded_successfully' => 'File uploaded successfully!',
            'upload_failed' => 'Upload failed. Please try again.',
            'file_deleted_successfully' => 'File deleted successfully!',
            'failed_to_delete_file' => 'Failed to delete file. Please try again.',
            'update_installed_successfully' => 'Update installed successfully! Application files have been updated.',
            'installation_failed' => 'Installation Failed',
            'failed_to_install_update' => 'Failed to install update. Please try again.',
            'only_zip_files_allowed' => 'Only ZIP files are allowed!',
            'file_size_must_be_less_than_100mb' => 'File size must be less than 100MB!',
            'update_complete' => 'Update Complete!',
            'reloading_page' => 'Reloading page in {0} seconds...',
            'reloading_message' => 'The application has been updated successfully. The page will reload automatically to apply the changes.',
            'reload_now' => 'Reload Now',
        ],
        'langs' => [
            'add' => 'Add New Language',
            'edit' => 'Edit Language',
            'details' => 'Language Details',
            'created' => 'Language Created Successfully',
            'updated' => 'Language Updated Successfully',
            'deleted' => 'Language Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this language?',
            'selected_delete_message' => 'Are you sure you want to delete selected language?',
            'view_all_langs' => 'View All Languages',
            'status_updated' => 'Langugage status updated',
            'name' => 'Name',
            'key' => 'Key',
            'flag' => 'Flag',
            'enabled' => 'Enabled',
            'is_rtl' => 'Text Direction',
            'rtl' => 'RTL',
            'ltr' => 'LTR',
        ],
        'pdf_fonts' => [
            'pdf_header_color' => 'PDF Header Color',
            'pdf_show_company_name' => 'Pdf Show Company Name',
            'pdf_show_company_email' => 'Pdf Show Company Email',
            'pdf_show_company_phone' => 'Pdf Show Company Phone',
            'pdf_show_company_address' => 'Pdf Show Company Address',
            'title_show_in_pdf' => 'Title Show In Pdf',
            'pdf_left_space' => 'Pdf Left Space',
            'pdf_right_space' => 'Pdf Right Space',
            'pdf_top_space' => 'Pdf Top Space',
            'pdf_bottom_space' => 'Pdf Bottom Space',
            'pdf_font_size' => 'Pdf Font Size',
            'pdf_line_height' => 'Pdf Line Height',
            'generate_sample_pdf' => 'Generate Sample PDF',
        ],
        'translations' => [
            'fetch_new_translations' => 'Fetch New Translations',
            'reload_translations' => 'Reload Translations',
            'reload_successfully' => 'Translations Reload Successfully',
            'fetched_successfully' => 'Translations Fetch Successfully',
            'import_translations' => 'Import Translations',
        ],
        'storage_settings' => [
            'updated' => 'Storage Settings Updated',
            'storage' => 'Storage',
            'local' => 'Local',
            'aws' => 'AWS S3 Storage',
            'aws_key' => 'AWS Key',
            'aws_secret' => 'AWS Secret',
            'aws_region' => 'AWS Region',
            'aws_bucket' => 'AWS Bucket',
            'upload_test_sample' => 'Upload Test Sample',
            'click_or_drag_file' => 'Click or drag file to this area to upload',
            'upload_test_hint' => 'Upload a test file to verify your storage configuration',
            'testing_storage' => 'Testing Storage:',
            'upload_test_success' => 'Test file uploaded successfully to {storage} storage!',
            'upload_test_failed' => 'Failed to upload test file. Please check your storage configuration.',
            'file_too_large' => 'File must be smaller than 10MB!',
            'aws_configuration' => 'AWS Configuration',
            'aws_config_description' => 'Configure your AWS S3 credentials below.',
            'view_instructions' => 'View Instructions',
            'aws_setup_instructions' => 'AWS S3 Setup Instructions',
            'step_1' => 'Step 1: Create an AWS Account',
            'step_1_description' => 'If you don\'t have an AWS account, sign up at',
            'step_2' => 'Step 2: Create an S3 Bucket',
            'step_2_1' => 'Go to AWS S3 Console',
            'step_2_2' => 'Click "Create bucket"',
            'step_2_3' => 'Enter a unique bucket name',
            'step_2_4' => 'Select your preferred region',
            'step_2_5' => 'Configure other settings as needed and create the bucket',
            'step_3' => 'Step 3: Create IAM User and Get Credentials',
            'step_3_1' => 'Go to AWS IAM Console',
            'step_3_2' => 'Click "Users" → "Add user"',
            'step_3_3' => 'Enter a username and select "Programmatic access"',
            'step_3_4' => 'Attach policy "AmazonS3FullAccess" (or create custom policy)',
            'step_3_5' => 'Complete the user creation and save the Access Key ID and Secret Access Key',
            'step_4' => 'Step 4: Enter Credentials',
            'aws_key_description' => 'Your AWS Access Key ID',
            'aws_secret_description' => 'Your AWS Secret Access Key',
            'aws_region_description' => 'The region where your S3 bucket is located (e.g., us-east-1)',
            'aws_bucket_description' => 'Your S3 bucket name',
            'security_note' => 'Security Note',
            'security_note_description' => 'Keep your AWS credentials secure. Never share them publicly or commit them to version control.',
        ],
        'staff_member' => [
            'add' => 'Add New Staff Member',
            'edit' => 'Edit Staff Member',
            'created' => 'Staff Member Created Successfully',
            'updated' => 'Staff Member Updated Successfully',
            'deleted' => 'Staff Member Deleted Successfully',
            'staff_member_details' => 'Staff Member Details',
            'staff_member' => 'Staff Member',
            'delete_message' => 'Are you sure you want to delete this staff member?',
            'selected_delete_message' => 'Are you sure you want to delete selected staff member?',
            'import_staff_members' => 'Import Staff Member',
            'profile_updated' => 'Profile Updated Successfully',
            'password_blank' => "Leave blank if you don't want to update password.",
            'name' => 'Name',
            'phone' => 'Phone',
            'email' => 'Email',
            'email_phone' => 'Email / Phone',
            'password' => 'Password',
            'profile_image' => 'Profile Image',
            'status' => 'Status',
            'address' => 'Address',
            'created_at' => 'Created At',
            'allow_login' => 'Allow Login',
            'role' => 'Role',
            'generate_password' => 'Generate Password',
            'details' => 'Staff Member Details',
            'quick_add' => 'Quick Add',
            'add_another' => 'Add Another Staff Member',
            'create_all' => 'Create All',
            'bulk_created' => 'Staff Members Created Successfully',
            'send_mail' => 'Send Mail',
            'are_you_sure_send_mail_user' => 'Are you sure you want to send mail to this user?',
            'mail_sent' => 'Mail Sent Successfully',
            'import' => 'Import',
            'import_staff_members' => 'Import Staff Members',
            'upload_file' => 'Upload File',
            'upload_file_desc' => 'Select CSV or Excel',
            'map_columns' => 'Map Columns',
            'map_columns_desc' => 'Match fields',
            'preview' => 'Preview',
            'preview_desc' => 'Review data',
            'results' => 'Results',
            'results_desc' => 'Import summary',
            'import_file_hint' => 'Support for CSV and Excel files (.csv, .xlsx, .xls)',
            'file_column' => 'File Column',
            'sample_data' => 'Sample Data',
            'map_to' => 'Map To',
            'select_field' => 'Select field to map',
            'map_columns_info' => 'Map your file columns to the corresponding database fields. Required fields are marked with *',
            'missing_required_fields' => 'Please map the following required fields',
            'preview_info' => '{0} records will be imported',
            'start_import' => 'Start Import',
            'import_records' => 'Import {0} Records',
            'import_success' => 'Import Successful',
            'import_success_message' => '{0} staff members have been imported successfully',
            'import_partial' => 'Import Completed with Errors',
            'import_partial_message' => '{0} imported, {1} failed',
            'view_errors' => 'View Error Details',
            'row' => 'Row',
            'empty_file' => 'The uploaded file is empty',
            'parse_error' => 'Error parsing file. Please check the file format.',
            'read_error' => 'Error reading file',
            'all_columns' => 'All Columns',
            'matched_columns' => 'Matched Columns',
            'unmatched_columns' => 'Unmatched Columns',
            'match_all' => 'Match All',
            'unmatch_all' => 'Unmatch All',
            'upload_new_file' => 'Upload New File',
            'review_data' => 'Review Data',
        ],
        'pdf_font' => [
            'add' => 'Add New Pdf Font',
            'edit' => 'Edit Pdf Font',
            'created' => 'Pdf Font Created Successfully',
            'updated' => 'Pdf Font Updated Successfully',
            'deleted' => 'Pdf Font Deleted Successfully',
            'appreciation_details' => 'Pdf Font Details',
            'delete_message' => 'Are you sure you want to delete this pdf font?',
            'name' => 'Name',
            'file' => 'File (.ttf)',
            'user_kashida' => 'Use Kashida',
            'user_kashida_tooltip' => 'Kashida is used for Arabic text justification. Enable this if your font supports Arabic script and you want proper text stretching for justified alignment.',
            'use_otl' => 'Use OTL',
            'use_otl_tooltip' => 'OpenType Layout (OTL) enables advanced typographic features for complex scripts like Hindi (Devanagari), Arabic, Thai, etc. Enable this for proper character shaping and ligatures.',
            'pdf_settings' => 'Pdf Settings',
            'use_custom_font' => 'Use Custom Font',
            'current' => 'Current',
            'font_settings' => 'Font Settings',
            'appearance' => 'Appearance',
            'spacing' => 'Spacing',
            'pdf_font_size' => 'Pdf Font Size',
            "holiday_pdf" => "Holiday Pdf",
            'generate_pdf' => 'Generate Pdf',
            'generate_sample_pdf' => 'Generate Sample PDF',
            'select_template' => 'Select Template',
            'template_default' => 'Default Sample',
            'template_invoice' => 'Invoice',
            'template_quotation' => 'Quotation',
            'template_receipt' => 'Receipt',
            'template_report' => 'Business Report',
        ],
        'email_template' => [
            'edit' => 'Edit Email Template',
            'updated' => 'Department Updated Successfully',
            'name' => 'Name',
            'type' => 'Type',
            'subject' => 'Email Subject',
            'body' => 'Email Body',
            'available_variable' => 'Available Variables',
        ],
        'mail_settings' => [
            'updated' => 'Mail Settings Updated',
            'mail_driver' => 'Mail Driver',
            'none' => 'None',
            'mail' => 'Mail',
            'smtp' => 'SMTP',
            'from_name' => 'Mail From Name',
            'from_email' => 'Mail From Email',
            'host' => 'Host',
            'port' => 'Port',
            'encryption' => 'Encryption',
            'username' => 'Username',
            'password' => 'Password',
            'send_test_mail' => 'Send Test Mail',
            'send_mail_setting_saved' => 'Send mail setting saved',
            'enable_mail_queue' => 'Enable Mail Queue',
            'send_mail_for' => 'Send Mail To',
            'email' => 'Email address for which you want to send test mail',
            'test_mail_sent_successfully' => 'Test mail sent successfully',
            'notificaiton_will_be_sent_to_company' => 'Notification will be sent to company email',
            'notificaiton_will_be_sent_to_employee' => 'Notification will be sent to employee email',
            'company' => 'Company',
            'staff_member' => 'Staff Member',
            'employee' => 'Staff Member',
            'on_welcome_mail' => 'Staff Member Welcome Mail',
        ],
        'database_backup' => [
            'file' => 'File',
            'file_size' => 'File Size',
            'file_type' => 'Type',
            'generate_backup' => 'Generate Backup',
            'delete_backup' => 'Delete Backup',
            'backup_generated_successfully' => 'Backup Generated Successfully',
            'are_you_sure_generate_backup' => 'Are you sure you want to generate database backup?',
            'are_you_sure_generate_backup_type' => 'Are you sure you want to generate database backup in {0} format?',
            'are_you_sure_delete_backup' => 'Are you sure you want to delete this database backup?',
            'backup_locaion_is' => 'All generated database file will be stored in storage/app/public/backup folder.',
            'settings' => 'Settings',
            'backup_command_setting' => 'MySQL Dump Path Settings',
            'mysqldump_command_path' => 'mysqldump command path',
            'command_updated' => 'Command updated successfully',
            'auto_detection_info' => 'The system automatically detects mysqldump path. If auto-detection fails, you can manually set DUMP_PATH in .env file.',
            'common_paths' => 'Common mysqldump paths by environment:',
            'cpanel_path' => 'cPanel / Linux Server',
            'xampp_windows_path' => 'XAMPP (Windows)',
            'xampp_linux_path' => 'XAMPP (Linux)',
            'laragon_path' => 'Laragon (Windows)',
            'wamp_path' => 'WAMP (Windows)',
            'mamp_path' => 'MAMP (macOS)',
            'homebrew_path' => 'Homebrew (macOS)',
            'find_path_command' => 'To find your mysqldump path, run this command in terminal:',
            'env_setting' => 'Then add to .env file:',
            'window_command_path' => 'If you use XAMPP then it will be => C:\\xampp\\mysql\\bin\\mysqldump.exe',
            'laragon_command_path' => 'If you use Laragon then it will be => C:\\laragon\\bin\\mysql\\mysql-5.7.24-winx64\\bin\\mysqldump.exe',
            'linux_command_path' => 'If you are on ubuntu or mac then run following command and enter output here => which mysqldump',
            'put_dump_path_command_on_env_file' => 'The system auto-detects mysqldump path. If backup fails, manually set DUMP_PATH in .env file.',
            'sql_format' => 'SQL (.sql)',
            'gzip_format' => 'GZIP (.sql.gz)',
            'zip_format' => 'ZIP (.zip)',
        ],
        'messages' => [
            'somehing_went_wrong' => 'Something went wrong. Please contact to administrator.',
            'verify_success' => 'Successfully verified. Redirect to app...',
            'login_success' => 'Successfully login. Redirect to app...',
            'login_success_dashboard' => 'Successfully logged into app.',
            'click_here_to_find_purchase_code' => 'Click here to find your purchase code',
            'verification_successfull' => 'Verification successfully',
            'other_domain_linked' => 'Other domain linked',
            'other_domain_linked_with_purchase_code' => 'Other domain is already linked with your purchase code. Please enter your purchase code for more details...',
            'first_verify_module_message' => 'To enable please \n verify this module',
            'are_you_sure_install_message' => 'Are you sure you want to install?',
            'downloading_started_message' => 'Downloading started. Please wait ...',
            'file_extracting_message' => 'File extracteding. Please wait ...',
            'installation_success' => 'Installation successfully. Click here to reload page...',
            'are_you_sure_update_message' => 'Are you sure you want to update? Please take backup before update.',
            'stmp_success_message' => 'Your SMTP settings are correct..',
            'stmp_error_message' => 'Your SMTP settings are incorrect. Please update it to send mails',
            'uploading_failed' => 'Uploading failed',
            'loading_app_message' => 'Please wait... we are preparing something amazing for you',
            'fetching_product_details' => 'We are fetching product details. Please wait...',
            'product_is_upto_date' => 'You are on the latest version of app.',
            'new_app_version_avaialbe' => 'New app version {0} is available. Please update to get latest version.',
            'not_able_to_edit_order' => 'Only order status editable, other fields can not be editable becuase this order linked to some payments. Delete those payment(s) and try again.',
            'click_here_to_download_sample_file' => 'Click here to download sample csv file',
            'imported_successfully' => 'Imported Successfully',
            'company_admin_password_message' => 'Admin will login using this password. (Leave blank to keep current password)',
            'email_setting_not_configured' => 'Email setting not configured',
            'please_configure_email_settings' => 'Please configure your email settings to send emails. Click Here to configure email settings.',
        ],
        'popover' => [
            'auto_detect_timezone' => 'Allow auto detect timezone from browser for currently logged in user.',
            'click_here_to_copy_credentials' => 'Click here to copy {0} credentials',
        ],
        'topbar_add_button' => [
            'add_staff_member' => 'Add Staff Member',
            'add_currency' => 'Add Currency',
            'add_language' => 'Add Language',
            'add_role' => 'Add Role',
        ],
        'ai_settings' => [
            'progress' => 'Progress',
            'title' => 'AI Settings',
            'updated' => 'AI Settings Updated Successfully',
            'provider' => 'AI Provider',
            'select_provider' => 'Select AI Provider',
            'none' => 'None (Disable AI)',
            'openai' => 'OpenAI',
            'claude' => 'Claude (Anthropic)',
            'api_key' => 'API Key',
            'model' => 'Model',
            'max_tokens' => 'Max Tokens',
            'test_connection' => 'Test Connection',
            'connection_success' => 'Connection successful! AI provider is configured correctly.',
            'connection_failed' => 'Connection failed. Please check your API key and try again.',
            'configuration' => 'AI Configuration',
            'config_description' => 'Configure your AI provider to enable content generation and translation features.',
            'view_instructions' => 'View Instructions',
            'setup_instructions' => 'AI Setup Instructions',
            'openai_step_1' => 'Step 1: Create an OpenAI Account',
            'openai_step_1_description' => 'Sign up at',
            'openai_step_2' => 'Step 2: Generate API Key',
            'openai_step_2_1' => 'Go to API Keys section in your OpenAI dashboard',
            'openai_step_2_2' => 'Click "Create new secret key"',
            'openai_step_2_3' => 'Copy the key and save it securely',
            'claude_step_1' => 'Step 1: Create an Anthropic Account',
            'claude_step_1_description' => 'Sign up at',
            'claude_step_2' => 'Step 2: Generate API Key',
            'claude_step_2_1' => 'Go to API Keys section in your Anthropic console',
            'claude_step_2_2' => 'Click "Create Key"',
            'claude_step_2_3' => 'Copy the key and save it securely',
            'perplexity' => 'Perplexity AI',
            'perplexity_step_1' => 'Step 1: Create a Perplexity Account',
            'perplexity_step_1_description' => 'Sign up at',
            'perplexity_step_2' => 'Step 2: Generate API Key',
            'perplexity_step_2_1' => 'Go to API Settings in your Perplexity account',
            'perplexity_step_2_2' => 'Click "Generate" to create a new API key',
            'perplexity_step_2_3' => 'Copy the key and save it securely',
            // Ollama
            'ollama' => 'Ollama (Self-Hosted)',
            'ollama_step_1' => 'Step 1: Install Ollama',
            'ollama_step_1_description' => 'Download and install Ollama from',
            'ollama_step_2' => 'Step 2: Pull a Model',
            'ollama_step_2_1' => 'Open your terminal',
            'ollama_step_2_2' => 'Run: ollama pull llama3.2 (or another model)',
            'ollama_step_2_3' => 'Wait for the model to download',
            'ollama_step_3' => 'Step 3: Start Ollama Server',
            'ollama_step_3_1' => 'Run: ollama serve (if not already running)',
            'ollama_step_3_2' => 'The server will be available at http://localhost:11434',
            'ollama_note' => 'Important Note',
            'ollama_note_description' => 'Ollama runs locally on your machine. Make sure the Ollama server is running before testing the connection. No API key is required for local use.',
            'ollama_base_url_hint' => 'Default: http://localhost:11434 for local installation',
            'ollama_model_hint' => 'Enter the model name you have pulled (e.g., llama3.2, mistral, codellama, qwen2.5:7b)',
            // OpenAI-compatible
            'openai_compatible' => 'OpenAI Compatible',
            'openai_compatible_step_1' => 'Step 1: Choose a Provider',
            'openai_compatible_step_1_description' => 'Select an OpenAI-compatible API provider:',
            'groq_description' => 'Very fast inference, free tier available',
            'together_description' => 'Wide model selection, competitive pricing',
            'openrouter_description' => 'Access multiple providers through one API',
            'openai_compatible_step_2' => 'Step 2: Get API Credentials',
            'openai_compatible_step_2_1' => 'Create an account with your chosen provider',
            'openai_compatible_step_2_2' => 'Navigate to API settings and generate an API key',
            'openai_compatible_step_2_3' => 'Copy the base URL and API key',
            'common_base_urls' => 'Common Base URLs',
            'openai_compatible_base_url_hint' => 'Enter the API base URL (e.g., https://api.groq.com/openai/v1)',
            'base_url' => 'Base URL',
            'api_key_optional' => 'API key is optional for local Ollama installations',
            // Provider groups
            'cloud_providers' => 'Cloud Providers',
            'self_hosted' => 'Self-Hosted / OpenAI Compatible',
            'security_note' => 'Security Note',
            'security_note_description' => 'Keep your API keys secure. Never share them publicly or commit them to version control.',
            'not_configured' => 'AI is not configured. Please configure AI settings first.',
            // AI Website Wizard
            'ai_website_wizard' => 'AI Website Wizard',
            'features_access' => 'AI Features Access',
            'wizard_description_help' => 'Describe your business or website in a few sentences. AI will extract the details and help you set up your website quickly.',
            'describe_your_website' => 'Describe Your Website',
            'wizard_placeholder' => 'Example: I want to create a website for my coffee shop called "Bean & Brew" in New York. We serve artisan coffee and pastries. I want a modern, warm design with brown and cream colors. The website should be in English and Spanish.',
            'analyze_and_extract' => 'Analyze & Extract Data',
            'analyzing' => 'Analyzing...',
            'review_extracted_data' => 'AI has extracted the following information. Review and modify if needed.',
            'please_enter_description' => 'Please enter a description of your website',
            'extraction_failed' => 'Failed to extract data. Please try again.',
            'apply_to_form' => 'Apply to Form',
            'generated_suggestions' => 'AI Generated Suggestions',
            'suggested_tagline' => 'Suggested Tagline',
            'suggested_description' => 'Suggested Description',
            // Wizard tabs
            'wizard_tab_basic' => 'Basic Settings',
            'wizard_tab_website' => 'Website Content',
            'wizard_tab_seo' => 'SEO Settings',
            'characters' => 'characters',
            'seo_keywords_placeholder' => 'keyword1, keyword2, keyword3',
            // Wizard validation
            'slug_format_error' => 'Slug must contain only lowercase letters, numbers, and hyphens',
            'color_format_error' => 'Color must be a valid hex color (e.g., #3B82F6)',
            'languages_required' => 'At least one language is required',
            'create_website' => 'Create Website',
            // New wizard UI translations
            'wizard_subtitle' => 'Create your website with AI assistance',
            'configure_ai_first' => 'Please configure AI settings in the admin panel to use this feature.',
            'phase_website' => 'Website Setup',
            'phase_website_desc' => 'Create your website',
            'phase_pages' => 'Generate Pages',
            'phase_pages_desc' => 'AI-powered page creation',
            'hint_business_name' => 'Include your business name',
            'hint_languages' => 'Mention languages needed',
            'hint_colors' => 'Describe your brand colors',
            'review_and_adjust' => 'Review the extracted data and make any adjustments before creating your website.',
            // Phase 2: Page Generation
            'website_created_success' => 'Website Created Successfully!',
            'now_generate_pages' => 'Now let\'s generate pages for your website using AI.',
            'generate_pages_title' => 'Generate Website Pages',
            'generate_pages_description' => 'AI will create appropriate pages based on your business type and requirements.',
            'page_requirements_label' => 'Page Requirements (Optional)',
            'page_requirements_placeholder' => 'Example: I need pages for home, about us, services (web design, mobile apps, SEO), portfolio, pricing, and contact. Include a blog section too.',
            'page_requirements_hint' => 'If left empty, AI will generate pages based on your website category and description.',
            'generate_pages' => 'Generate Pages',
            'generating_pages' => 'Generating...',
            'skip_page_generation' => 'Skip & Finish',
            'page_generation_failed' => 'Failed to generate pages. Please try again.',
            'generated_pages_title' => 'Generated Pages',
            'generated_pages_description' => 'Review and toggle the pages you want to create. You can edit the page names for each language.',
            'show_in_header' => 'Header Menu',
            'save_pages' => 'Save Pages',
            'select_at_least_one_page' => 'Please select at least one page to save.',
            'pages_saved_success' => 'Pages have been created successfully!',
            // Page switch instructions
            'page_switch_instruction' => 'Use the toggle switch to include or exclude pages. Disabled pages will not be created.',
            'page_will_be_created' => 'This page will be created',
            'page_will_not_be_created' => 'This page will NOT be created',
            'home_page_required' => 'Home page is required and cannot be disabled',
            'required_page' => 'Required',
            'save_and_continue' => 'Save & Continue',
            // Phase 3: Legal Pages
            'phase_legal_pages' => 'Legal Pages',
            'phase_legal_pages_desc' => 'Privacy, Terms & more',
            'pages_created_success' => 'Website Pages Created Successfully!',
            'now_generate_legal_pages' => 'Now let\'s generate legal pages (Privacy Policy, Terms of Service, etc.) for your website.',
            'select_legal_pages_title' => 'Select Legal Pages to Generate',
            'select_legal_pages_description' => 'Choose which legal pages you want to create. AI will generate content for each selected page.',
            'generate_legal_pages_title' => 'Generate Legal Pages',
            'generate_legal_pages_description' => 'AI will create professional legal pages customized for your business.',
            'legal_page_requirements_label' => 'Additional Requirements (Optional)',
            'legal_page_requirements_placeholder' => 'Example: Include a section about GDPR compliance. Add refund policy specific to our 30-day money-back guarantee. Mention that we don\'t share data with third parties for marketing.',
            'legal_page_requirements_hint' => 'If left empty, AI will generate standard legal pages based on your business type.',
            'default_legal_pages' => 'Default legal pages that will be generated:',
            'generate_legal_pages' => 'Generate Legal Pages',
            'generating_legal_pages' => 'Generating Legal Pages',
            'generating_legal_pages_progress_description' => 'AI is generating content for each selected page and language. This may take a few moments.',
            'pages_generated' => 'pages generated',
            'generating_page' => 'Generating: {0}...',
            'skip_and_finish' => 'Skip & Finish',
            'legal_page_generation_failed' => 'Failed to generate legal pages. Please try again.',
            'legal_page_suggestions_failed' => 'Failed to generate legal page suggestions. Please try again.',
            'generate_suggestions' => 'Generate Suggestions',
            'generating_suggestions' => 'Generating suggestions...',
            'legal_page_select_instruction' => 'Select the legal pages you want to generate. AI will create content for each selected page.',
            'generated_legal_pages_title' => 'Generated Legal Pages',
            'generated_legal_pages_description' => 'Review and edit the legal pages. Click on a page to view and modify its content.',
            'legal_page_switch_instruction' => 'Use the toggle switch to include or exclude legal pages. Disabled pages will not be created.',
            'select_at_least_one_legal_page' => 'Please select at least one legal page.',
            'legal_pages_saved_success' => 'Legal pages have been created successfully!',
            'save_and_finish' => 'Save & Finish',
            'generate_with_ai' => 'Generate with AI',
            'no_languages_configured' => 'Please configure at least one language for this website first.',
            'page_exists_will_update' => 'Exists - Will Update',
            'skip_legal_pages' => 'Skip Legal Pages',
            // Phase 4: Website Sections
            'phase_sections' => 'Sections',
            'phase_sections_desc' => 'Build page layouts',
            'generate_website_sections' => 'Generate Website Sections',
            'sections_generation_desc' => 'AI will create appropriate sections for each page based on your business type.',
            'section_requirements' => 'Section Requirements',
            'section_requirements_placeholder' => 'Example: I want a hero section with a call-to-action button, a features section highlighting our services, and a testimonials section.',
            'section_requirements_hint' => 'If left empty, AI will suggest appropriate sections based on your business category and page types.',
            'pages_count' => 'Pages',
            'selected_page' => 'Selected Page',
            'generate_page_sections' => 'Generate Sections for {0}',
            'now_generate_sections' => 'Now let\'s generate sections to build your website pages.',
            'review_suggested_sections' => 'Review Suggested Sections',
            'select_sections_to_generate' => 'Select which sections you want to generate content for.',
            'selected_sections_count' => '{0} sections selected',
            'generating_section_content' => 'Generating Section Content',
            'please_wait_generating' => 'Please wait while AI generates content for each section...',
            'sections_generated' => 'Sections Generated Successfully!',
            'ready_to_save' => 'Review the generated sections and save them to your website.',
            'generate_content' => 'Generate Content',
            'generating' => 'Generating...',
            'save_sections' => 'Save Sections',
            'sections_saved_success' => 'Website sections have been created successfully!',
            'select_at_least_one_section' => 'Please select at least one section.',
            'no_sections_to_save' => 'No sections to save.',
            'section_generation_failed' => 'Failed to generate section suggestions. Please try again.',
        ],
        'website_setting' => [
            // CRUD Messages
            'add' => 'Add Website Setting',
            'edit' => 'Edit Website Setting',
            'created' => 'Website Setting Created Successfully',
            'updated' => 'Website Setting Updated Successfully',
            'deleted' => 'Website Setting Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this website setting?',
            'details' => 'Website Setting Details',

            // General
            'module_name' => 'Module Name',
            'is_global' => 'Is Global',
            'status' => 'Status',

            // Theme Configuration
            'theme_settings' => 'Theme Settings',
            'theme_primary_color' => 'Primary Color',
            'theme_secondary_color' => 'Secondary Color',
            'theme_mode' => 'Theme Mode',
            'theme_direction' => 'Theme Direction',
            'light' => 'Light',
            'dark' => 'Dark',
            'ltr' => 'LTR (Left to Right)',
            'rtl' => 'RTL (Right to Left)',

            // SEO Configuration
            'seo_settings' => 'SEO Settings',
            'seo_title' => 'SEO Title',
            'seo_description' => 'SEO Description',
            'seo_keywords' => 'SEO Keywords',
            'seo_author' => 'SEO Author',
            'seo_robots' => 'SEO Robots',
            'seo_og_type' => 'Open Graph Type',
            'seo_og_locale' => 'Open Graph Locale',
            'seo_og_site_name' => 'Open Graph Site Name',
            'seo_og_image' => 'Open Graph Image',
            'seo_twitter_card' => 'Twitter Card Type',
            'seo_twitter_site' => 'Twitter Site Handle',
            'seo_twitter_creator' => 'Twitter Creator Handle',

            // Company Info
            'company_settings' => 'Company Settings',
            'company_name' => 'Company Name',
            'company_tagline' => 'Company Tagline',
            'company_phone' => 'Company Phone',
            'company_email' => 'Company Email',
            'company_address' => 'Company Address',
            'company_hours' => 'Business Hours',
            'company_logo' => 'Company Logo',
            'company_favicon' => 'Company Favicon',

            // Header Settings
            'header_settings' => 'Header Settings',
            'header_show_phone' => 'Show Phone in Header',
            'header_sticky' => 'Sticky Header',
            'header_show_theme_toggle' => 'Show Theme Toggle',

            // Navigation Labels
            'navigation_settings' => 'Navigation Settings',
            'nav_services' => 'Services Label',
            'nav_how_it_works' => 'How It Works Label',
            'nav_pricing' => 'Pricing Label',
            'nav_reviews' => 'Reviews Label',
            'nav_faq' => 'FAQ Label',
            'nav_contact' => 'Contact Label',
            'nav_schedule_pickup' => 'Schedule Pickup Label',

            // Social Links
            'social_settings' => 'Social Media Settings',
            'social_links' => 'Social Links',
            'social_name' => 'Social Network Name',
            'social_url' => 'Social URL',
            'social_icon' => 'Social Icon',
            'add_social_link' => 'Add Social Link',

            // Footer Settings
            'footer_settings' => 'Footer Settings',
            'footer_description' => 'Footer Description',
            'footer_quick_links_title' => 'Quick Links Title',
            'footer_services_title' => 'Services Title',
            'footer_contact_title' => 'Contact Title',
            'footer_copyright' => 'Copyright Text',
            'footer_show_social' => 'Show Social Links in Footer',
            'footer_legal_links' => 'Legal Links',
            'add_legal_link' => 'Add Legal Link',
            'legal_link_title' => 'Link Title',
            'legal_link_url' => 'Link URL',
        ],
    ];

    public static $eStoreTranslations = [];

    public static function getTranslationArray($moduleName)
    {
        if ($moduleName == 'Estore') {
            return self::$eStoreTranslations;
        } else if ($moduleName == 'Superadmin') {
            return \App\SuperAdmin\Classes\SuperAdminLangTrans::$mainTranslations;
        }

        return self::$mainTranslations;
    }

    public static function seedTranslations($moduleName = '')
    {
        $translations = self::getTranslationArray($moduleName);

        self::seedCustomTranslations($translations);
    }

    public static function seedCustomTranslations($translations, $moduleName = '')
    {
        $allLangs = Lang::all();

        foreach ($translations as $group => $translation) {
            foreach ($translation as $transKey => $transValue) {

                foreach ($allLangs as $allLang) {
                    $translationCount = Translation::where('lang_id', $allLang->id)
                        ->where('group', $group)
                        ->where('key', $transKey);

                    if ($moduleName != '') {
                        $translationCount = $translationCount->where('module_name', $moduleName);
                    }

                    $translationCount = $translationCount->count();

                    if ($translationCount == 0) {
                        $newTranslation = new Translation();
                        $newTranslation->lang_id = $allLang->id;
                        $newTranslation->group = $group;
                        $newTranslation->key = $transKey;
                        $newTranslation->value = $transValue;
                        if ($moduleName != '') {
                            $newTranslation->module_name = $moduleName;
                        }

                        $newTranslation->save();
                    }
                }
            }
        }
    }

    public static function seedMainTranslations()
    {
        // Main Module
        self::seedTranslations();

        // Seed translations from all files in LangTrans folder
        $langTransPath = app_path('Classes/LangTrans');
        if (is_dir($langTransPath)) {
            $files = scandir($langTransPath);
            foreach ($files as $file) {
                if (pathinfo($file, PATHINFO_EXTENSION) === 'php') {
                    $className = 'App\\Classes\\LangTrans\\' . pathinfo($file, PATHINFO_FILENAME);
                    if (class_exists($className) && property_exists($className, 'translations')) {
                        self::seedCustomTranslations($className::$translations);
                    }
                }
            }
        }

        // Seed Translation for SAAS Version
        if (app_type() == 'saas') {
            self::seedTranslations('Superadmin');
        }
    }

    public static function seedAllModulesTranslations()
    {
        // Main Module
        self::seedMainTranslations();

        // Get active module folder names
        $activeModuleFolders = ModuleAssets::getActiveModuleFolders();

        foreach ($activeModuleFolders as $moduleFolderName) {
            self::seedModuleTranslations($moduleFolderName);
        }
    }

    public static function seedModuleTranslations($moduleName)
    {
        $translations = [];

        $path = base_path("Modules/{$moduleName}/app/Classes/LangTrans");

        // Check if directory exists
        if (!File::isDirectory($path)) {
            return [];
        }

        // Get all PHP files under this directory
        $files = File::allFiles($path);

        foreach ($files as $file) {
            $filePath = $file->getPathname();

            // Get namespace and class name
            $className = self::getFullClassName($filePath);

            if ($className && class_exists($className)) {
                $reflection = new ReflectionClass($className);

                if ($reflection->hasProperty('translations')) {
                    $property = $reflection->getProperty('translations');

                    if ($property->isStatic()) {
                        $translations = $property->getValue();

                        self::seedCustomTranslations($translations, $moduleName);
                    }
                }
            }
        }
    }

    /**
     * Extract full class name (namespace + class) from file.
     */
    protected static function getFullClassName(string $filePath): ?string
    {
        $contents = file_get_contents($filePath);

        if (
            preg_match('/namespace\s+([^;]+);/', $contents, $namespaceMatch) &&
            preg_match('/class\s+([^\s]+)/', $contents, $classMatch)
        ) {
            return $namespaceMatch[1] . '\\' . $classMatch[1];
        }

        return null;
    }
}
