<?php

namespace App\Classes\LangTrans;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class WebsiteBuilderLangTrans
{
    private static $baseTranslations = [
        'menu' => [
            'website_builder' => 'Website Builder',
        ],
        'website_builder' => [
            // CRUD Messages
            'add' => 'Add Section',
            'edit' => 'Edit Section',
            'created' => 'Section Created Successfully',
            'updated' => 'Section Updated Successfully',
            'deleted' => 'Section Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this section?',
            'details' => 'Section Details',

            // Form Fields
            'section_key' => 'Section Key',
            'section_layout' => 'Section Layout',
            'icon' => 'Icon',
            'title' => 'Title',
            'subtitle' => 'Subtitle',
            'language' => 'Language',
            'select_page' => 'Select Page',
            'website_page' => 'Website Page',
            'content_data' => 'Content Data',
            'content_schema' => 'Content Schema',
            'sort_order' => 'Sort Order',
            'is_white_background' => 'White Background',
            'padding_top' => 'Custom Padding Top',
            'padding_bottom' => 'Custom Padding Bottom',
            'padding_help' => 'Enable to set custom padding in pixels. Leave off to use section default.',
            'padding_default' => 'Using section default',
            'front_form' => 'Custom Form',
            'front_form_help' => 'Select a form to display in this section (optional)',
            'form_layout' => 'Form Layout',
            'basic_info' => 'Basic Information',
            'select_section' => 'Please select a section to edit',
            'no_content_schema' => 'No content schema defined for this section',

            // Common Sections (Header/Footer)
            'common_header' => 'Common Header (All Pages)',
            'common_footer' => 'Common Footer (All Pages)',

            // Add Section Modal
            'add_section' => 'Add Section',
            'search_sections' => 'Search sections...',
            'no_sections_available' => 'No sections available',
            'no_sections_found' => 'No sections found',
            'already_added' => 'Already Added',
            'section_added' => 'Section added successfully',
            'failed_to_load_sections' => 'Failed to load sections',
            'failed_to_add_section' => 'Failed to add section',

            // Delete Section
            'delete_section' => 'Delete Section',
            'delete_section_confirm' => 'Are you sure you want to delete this section?',
            'delete_section_description' => 'This action cannot be undone. The section and all its content will be permanently deleted.',
            'section_deleted' => 'Section deleted successfully',
            'failed_to_delete_section' => 'Failed to delete section',

            // Sort Order
            'sort_order_updated' => 'Sort order updated successfully',

            // Section Layout Modal
            'select_section_layout' => 'Select Section Layout',
            'no_layouts_available' => 'No layouts available for this section',
            'change_layout' => 'Change Layout',
            'no_layout_selected' => 'No layout selected',
            'no_preview' => 'No preview available',
            'selected' => 'Selected',
            'current' => 'Current',
            'layouts_found' => 'layouts found',
        ],
    ];

    /**
     * Dynamic translations property - populated at runtime
     */
    public static $translations = [];

    /**
     * Get translations with dynamically merged section names from database
     */
    public static function getTranslations(): array
    {
        $translations = self::$baseTranslations;

        // Merge dynamic section names from theme_sections table
        $dynamicSections = self::getDynamicSectionTranslations();
        $translations['website_builder'] = array_merge(
            $translations['website_builder'],
            $dynamicSections
        );

        return $translations;
    }

    /**
     * Get dynamic section translations from theme_sections table
     * Includes section names and field translations from content_schema
     */
    private static function getDynamicSectionTranslations(): array
    {
        $allTranslations = [];

        try {
            // Check if table exists to avoid errors during migrations
            if (Schema::hasTable('theme_sections')) {
                $themeSections = DB::table('theme_sections')
                    ->select('section_key', 'name', 'translations')
                    ->get();

                foreach ($themeSections as $section) {
                    // Create translation key like 'section_hero' => 'Hero Section'
                    $key = 'section_' . $section->section_key;
                    $allTranslations[$key] = $section->name;

                    // Merge field translations from the translations column
                    if (!empty($section->translations)) {
                        $fieldTranslations = json_decode($section->translations, true);
                        if (is_array($fieldTranslations)) {
                            $allTranslations = array_merge($allTranslations, $fieldTranslations);
                        }
                    }
                }
            }
        } catch (\Exception $e) {
            // Silently fail if database is not available
        }

        return $allTranslations;
    }

    /**
     * Initialize translations when accessed
     * Call this method before accessing $translations
     */
    public static function initTranslations(): void
    {
        self::$translations = self::getTranslations();
    }
}

// Initialize translations when class is loaded
WebsiteBuilderLangTrans::initTranslations();
