<?php

namespace App\Classes\LangTrans;

class WebsiteLangTrans
{
    public static $translations = [
        'website' => [
            'add' => 'Add New Website',
            'edit' => 'Edit Website',
            'created' => 'Website Created Successfully',
            'updated' => 'Website Updated Successfully',
            'deleted' => 'Website Deleted Successfully',
            'website_details' => 'Website Details',
            'delete_message' => 'Are you sure you want to delete this Website?',
            'selected_delete_message' => 'Are you sure you want to delete selected website?',
            'cannot_delete_selected_website' => 'You cannot delete the currently selected website. Please select a different website first.',
            'name' => 'Name',
            'slug' => 'Slug',
            'category' => 'Category',

            // Sections
            'basic_info' => 'Basic Information',
            'theme_settings' => 'Theme Settings',
            'basic_and_theme' => 'Basic Info & Theme',

            // Languages
            'languages_help' => 'Add languages for your website. The default language will be used when no language preference is set.',
            'add_language' => 'Add Language',

            // Theme
            'theme_name' => 'Theme',
            'theme_primary_color' => 'Primary Color',
            'theme_secondary_color' => 'Secondary Color',
            'theme_mode' => 'Theme Mode',
            'front_default_lang' => 'Default Language',
            'light' => 'Light',
            'dark' => 'Dark',

            // Landing Page URL
            'landing_page_url' => 'Landing Page URL',
            'copy_url' => 'Copy URL',
            'open_in_new_tab' => 'Open in New Tab',
            'visit_page' => 'Visit Page',
            'view_qr_code' => 'View QR Code',
            'download_qr' => 'Download QR Code',
            'url_copied' => 'URL copied to clipboard',
            'qr_downloaded' => 'QR Code downloaded',
            'no_landing_url' => 'No landing page URL available. Please set a slug for this website.',

            // Live Preview
            'landing_page_preview' => 'Landing Page Preview',
            'live_preview' => 'Live Preview',
            'click_to_visit' => 'Click to visit',
            'refresh_preview' => 'Refresh',
            'no_landing_url_short' => 'No URL Set',
            'no_sections' => 'No Sections Added',
            'add_sections_hint' => 'Add sections to display your landing page',
            'click_to_add_sections' => 'Click to add sections',
            'preview_mobile' => 'Mobile',
            'preview_desktop' => 'Desktop',
            'show_preview' => 'Show Preview',
            'hide_preview' => 'Hide Preview',
            'open_in_new_tab' => 'Open in New Tab',

            // Stats
            'total_websites' => 'Total Websites',

            // Switch Website Confirmation
            'switch_website_confirm_title' => 'Switch Website',
            'switch_website_confirm_content' => 'You need to switch to "{0}" to add sections. Do you want to switch now?',

            // Favourite
            'favourite' => 'Favourite',
            'favourites' => 'Favourites',
            'add_to_favourites' => 'Add to Favourites',
            'remove_from_favourites' => 'Remove from Favourites',
            'added_to_favourites' => 'Added to favourites',
            'removed_from_favourites' => 'Removed from favourites',

            // Primary Website (Root URL)
            'primary' => 'Primary',
            'is_primary' => 'Primary Website',
            'set_as_primary' => 'Set as Primary',
            'remove_as_primary' => 'Remove as Primary',
            'set_as_primary_success' => 'Set as primary website',
            'removed_as_primary_success' => 'Removed as primary website',
            'primary_help' => 'Primary website will be accessible at root URL (/)',
            'primary_badge' => 'Primary',

            // Header/Footer Settings
            'use_same_header_across_all_pages' => 'Use Same Header Across All Pages',
            'use_same_footer_across_all_pages' => 'Use Same Footer Across All Pages',
            'use_same_header_across_all_pages_help' => 'When enabled, if a header section is added to any page, it will automatically appear on all pages of this website. Any edits or deletions will also be applied across all pages.',
            'use_same_footer_across_all_pages_help' => 'When enabled, if a footer section is added to any page, it will automatically appear on all pages of this website. Any edits or deletions will also be applied across all pages.',

            // Custom Code
            'custom_code' => 'Custom Code',
            'custom_css' => 'Custom CSS',
            'custom_js' => 'Custom JavaScript',
            'custom_css_placeholder' => '/* Add your custom CSS here */\n\n.my-class {\n    color: #333;\n}',
            'custom_js_placeholder' => '// Add your custom JavaScript here\n\nconsole.log("Custom JS loaded");',
            'custom_code_warning' => 'Be careful when adding custom code. Invalid CSS or JavaScript may break your landing page.',
        ],
        'website_setting' => [
            'updated' => 'Website Settings Updated Successfully',
            'website_settings' => 'Website Settings',
            'seo_settings' => 'SEO Settings',
            'header_settings' => 'Header Settings',
            'social_settings' => 'Social Settings',
            'footer_settings' => 'Footer Settings',

            // Language
            'language' => 'Language',

            // Website Info
            'website_name' => 'Website Name',
            'website_tagline' => 'Tagline',
            'website_description' => 'Description',
            'website_description_help' => 'Short description displayed in footer',
            'website_phone' => 'Phone',
            'website_email' => 'Email',
            'website_address' => 'Address',
            'website_hours' => 'Business Hours',
            'website_favicon' => 'Favicon',
            'favicon_help' => 'Browser tab icon (recommended: 32x32px)',

            // Logo Settings
            'logo_settings' => 'Logo Settings',
            'light_logo' => 'Light Mode Logo',
            'dark_logo' => 'Dark Mode Logo',
            'light_logo_small' => 'Light Mode Logo (Small)',
            'dark_logo_small' => 'Dark Mode Logo (Small)',
            'light_logo_help' => 'Logo displayed in light theme',
            'dark_logo_help' => 'Logo displayed in dark theme',
            'small_logo_help' => 'Used when sidebar is collapsed',
            'header_logo_type' => 'Header/Footer Logo Display',
            'header_logo_type_help' => 'Choose how the logo appears in header and footer',
            'logo_with_name' => 'Small Logo + Website Name',
            'logo_only' => 'Small Logo Only',
            'light_dark_with_name' => 'Full Logo (Light/Dark) + Website Name',
            'light_dark_only' => 'Full Logo (Light/Dark) Only',

            // SEO
            'seo_title' => 'SEO Title',
            'seo_description' => 'SEO Description',
            'seo_keywords' => 'Keywords',
            'seo_author' => 'Author',
            'seo_robots' => 'Robots',
            'seo_og_type' => 'OG Type',
            'seo_og_locale' => 'OG Locale',
            'seo_og_site_name' => 'OG Site Name',
            'seo_og_image' => 'OG Image',
            'seo_twitter_card' => 'Twitter Card',
            'seo_twitter_site' => 'Twitter Site',
            'seo_twitter_creator' => 'Twitter Creator',

            // Header
            'header_show_phone' => 'Show Phone',
            'header_sticky' => 'Sticky Header',
            'header_show_theme_toggle' => 'Show Theme Toggle',

            // Social
            'show_social_icon' => 'Show Social Icons',
            'show_social_icon_help' => 'Display social icons in header, footer, and contact sections',
            'social_links' => 'Social Links',
            'social_name' => 'Name',
            'social_url' => 'URL',
            'social_icon' => 'Icon',
            'add_social_link' => 'Add Social Link',

            // Footer
            'footer_description' => 'Footer Description',
            'footer_quick_links_title' => 'Quick Links Title',
            'footer_services_title' => 'Services Title',
            'footer_contact_title' => 'Contact Title',
            'footer_copyright' => 'Copyright',
        ],
        'menu' => [
            'websites' => 'Websites',
        ],
    ];
}
