<?php

namespace App\Classes;

use App\Models\Permission;
use Nwidart\Modules\Facades\Module;
use Illuminate\Support\Facades\File;
use ReflectionClass;

class PermsSeed
{
    public static $mainPermissionsArray = [

        // Staff Members
        'staff_members_view' => [
            'name' => 'staff_members_view',
            'display_name' => 'Staff Member View'
        ],
        'staff_members_create' => [
            'name' => 'staff_members_create',
            'display_name' => 'Staff Member Create'
        ],
        'staff_members_edit' => [
            'name' => 'staff_members_edit',
            'display_name' => 'Staff Member Edit'
        ],
        'staff_members_delete' => [
            'name' => 'staff_members_delete',
            'display_name' => 'Staff Member Delete'
        ],

        // Pdf Fonts
        'pdf_fonts_view' => [
            'name' => 'pdf_fonts_view',
            'display_name' => 'Pdf Fonts View'
        ],
        'pdf_fonts_create' => [
            'name' => 'pdf_fonts_create',
            'display_name' => 'Pdf Fonts Create'
        ],
        'pdf_fonts_edit' => [
            'name' => 'pdf_fonts_edit',
            'display_name' => 'Pdf Fonts Edit'
        ],
        'pdf_fonts_delete' => [
            'name' => 'pdf_fonts_delete',
            'display_name' => 'Pdf Fonts Delete'
        ],

        // Icon Sets
        'icon_sets_view' => [
            'name' => 'icon_sets_view',
            'display_name' => 'Icon Sets View'
        ],
        'icon_sets_create' => [
            'name' => 'icon_sets_create',
            'display_name' => 'Icon Sets Create'
        ],
        'icon_sets_edit' => [
            'name' => 'icon_sets_edit',
            'display_name' => 'Icon Sets Edit'
        ],
        'icon_sets_delete' => [
            'name' => 'icon_sets_delete',
            'display_name' => 'Icon Sets Delete'
        ],

        // Currency
        'currencies_view' => [
            'name' => 'currencies_view',
            'display_name' => 'Currency View'
        ],
        'currencies_create' => [
            'name' => 'currencies_create',
            'display_name' => 'Currency Create'
        ],
        'currencies_edit' => [
            'name' => 'currencies_edit',
            'display_name' => 'Currency Edit'
        ],
        'currencies_delete' => [
            'name' => 'currencies_delete',
            'display_name' => 'Currency Delete'
        ],

        // Modules
        'modules_view' => [
            'name' => 'modules_view',
            'display_name' => 'Modules View'
        ],

        // Role
        'roles_view' => [
            'name' => 'roles_view',
            'display_name' => 'Role View'
        ],
        'roles_create' => [
            'name' => 'roles_create',
            'display_name' => 'Role Create'
        ],
        'roles_edit' => [
            'name' => 'roles_edit',
            'display_name' => 'Role Edit'
        ],
        'roles_delete' => [
            'name' => 'roles_delete',
            'display_name' => 'Role Delete'
        ],

        // Assign Role
        'assign_role' => [
            'name' => 'assign_role',
            'display_name' => 'Assign Role'
        ],

        // Company
        'companies_edit' => [
            'name' => 'companies_edit',
            'display_name' => 'Company Edit'
        ],

        // Translation
        'translations_view' => [
            'name' => 'translations_view',
            'display_name' => 'Translation View'
        ],
        'translations_create' => [
            'name' => 'translations_create',
            'display_name' => 'Translation Create'
        ],
        'translations_edit' => [
            'name' => 'translations_edit',
            'display_name' => 'Translation Edit'
        ],
        'translations_delete' => [
            'name' => 'translations_delete',
            'display_name' => 'Translation Delete'
        ],

        // Storage Settings
        'storage_edit' => [
            'name' => 'storage_edit',
            'display_name' => 'Storage Settings Edit'
        ],

        // Email Settings
        'email_edit' => [
            'name' => 'email_edit',
            'display_name' => 'Email Settings Edit'
        ],

        // AI Settings
        'ai_settings_edit' => [
            'name' => 'ai_settings_edit',
            'display_name' => 'AI Settings Edit'
        ],

        // AI Features Access
        'ai_features_access' => [
            'name' => 'ai_features_access',
            'display_name' => 'AI Features Access'
        ],

        // Update App
        'update_app' => [
            'name' => 'update_app',
            'display_name' => 'Update App'
        ],

    ];

    public static $eStorePermissions = [];

    public static function getPermissionArray($moduleName = '')
    {
        return self::$mainPermissionsArray;
    }

    public static function seedPermissions($moduleName = '')
    {
        $permissions = self::getPermissionArray($moduleName);

        self::seedCustomPermissions($permissions);
    }

    public static function seedCustomPermissions($permissions, $moduleName = '', $group = '')
    {
        foreach ($permissions as $key => $permission) {
            $permissionCount = Permission::where('name', $permission['name']);

            if ($moduleName != '') {
                $permissionCount = $permissionCount->where('module_name', $moduleName);
            }
            $permissionCount = $permissionCount->count();

            if ($permissionCount == 0) {
                $newPermission = new Permission();
                $newPermission->name = $permission['name'];
                $newPermission->display_name = $permission['display_name'];
                if ($moduleName != '') {
                    $newPermission->module_name = $moduleName;
                }
                if ($group != '') {
                    $newPermission->group = $group;
                }
                $newPermission->save();
            }
        }
    }

    public static function seedMainPermissions()
    {
        // Main Module
        self::seedPermissions();

        // Seed permissions from all files in PermsSeed folder
        $permsSeedPath = app_path('Classes/PermsSeed');
        if (is_dir($permsSeedPath)) {
            $files = scandir($permsSeedPath);
            foreach ($files as $file) {
                if (pathinfo($file, PATHINFO_EXTENSION) === 'php') {
                    $className = 'App\\Classes\\PermsSeed\\' . pathinfo($file, PATHINFO_FILENAME);
                    if (class_exists($className) && property_exists($className, 'permissions')) {
                        self::seedCustomPermissions($className::$permissions);
                    }
                }
            }
        }
    }

    public static function seedAllModulesPermissions()
    {
        // Main Module
        self::seedMainPermissions();

        $allModules = Module::all();
        foreach ($allModules as $allModule) {
            self::seedPermissions($allModule);
        }
    }

    public static function seedModulePermissions($moduleName)
    {
        $permissions = [];

        $path = base_path("Modules/{$moduleName}/app/Classes/PermsSeed");

        // Check if directory exists
        if (!File::isDirectory($path)) {
            return [];
        }

        // Get all PHP files under this directory
        $files = File::allFiles($path);

        foreach ($files as $file) {
            $filePath = $file->getPathname();

            // Get namespace and class name
            $className = self::getFullClassName($filePath);

            if ($className && class_exists($className)) {
                $reflection = new ReflectionClass($className);

                if ($reflection->hasProperty('permissions')) {
                    $property = $reflection->getProperty('permissions');

                    if ($property->isStatic()) {
                        $permissions = $property->getValue();

                        // Check if $group property exists
                        $group = '';
                        if ($reflection->hasProperty('group')) {
                            $groupProperty = $reflection->getProperty('group');
                            if ($groupProperty->isStatic()) {
                                $group = $groupProperty->getValue();
                            }
                        }

                        // If group is not defined, generate from filename
                        if (empty($group)) {
                            $fileName = pathinfo($file->getFilename(), PATHINFO_FILENAME);
                            // Remove 'PermsSeed' suffix and make plural
                            $group = str_replace('PermsSeed', '', $fileName);
                            $group = \Illuminate\Support\Str::plural($group);
                            $group = \Illuminate\Support\Str::snake($group);
                        }

                        self::seedCustomPermissions($permissions, $moduleName, $group);
                    }
                }
            }
        }
    }

    /**
     * Extract full class name (namespace + class) from file.
     */
    protected static function getFullClassName(string $filePath): ?string
    {
        $contents = file_get_contents($filePath);

        if (
            preg_match('/namespace\s+([^;]+);/', $contents, $namespaceMatch) &&
            preg_match('/class\s+([^\s]+)/', $contents, $classMatch)
        ) {
            return $namespaceMatch[1] . '\\' . $classMatch[1];
        }

        return null;
    }
}
