<?php

namespace App\Classes;

use Illuminate\Support\Facades\DB;

class ThemeSections
{
    public static $sections = [
        // ============================================================
        // HEADER SECTION
        // ============================================================
        [
            'section_key' => 'header',
            'name' => 'Header Section',
            'description' => 'Website header with navigation, logo, and configuration options.',
            'icon' => 'lucide:menu',
            'sort_order' => 0,
            'default_title' => null,
            'default_subtitle' => null,
            'default_content' => [
                'sticky' => true,
                'transparent' => false,
                'text_color_mode' => 'auto',
                'show_theme_toggle' => true,
                'cta_buttons' => [
                    ['text' => 'Schedule Pickup', 'url' => '#contact', 'icon' => 'lucide:calendar'],
                ],
                'more_text' => 'More',
            ],
            'content_schema' => [
                ['name' => 'sticky', 'label' => 'Sticky Header', 'type' => 'switch'],
                ['name' => 'transparent', 'label' => 'Transparent Background (until scroll)', 'type' => 'switch'],
                [
                    'name' => 'text_color_mode',
                    'label' => 'Text & Logo Color',
                    'type' => 'select',
                    'options' => [
                        ['value' => 'auto', 'label' => 'Auto (based on theme)'],
                        ['value' => 'light', 'label' => 'Light (white text)'],
                        ['value' => 'dark', 'label' => 'Dark (black text)'],
                    ]
                ],
                ['name' => 'show_theme_toggle', 'label' => 'Show Theme Toggle', 'type' => 'switch'],
                [
                    'name' => 'cta_buttons',
                    'label' => 'CTA Buttons',
                    'type' => 'repeater',
                    'fields' => [
                        ['name' => 'text', 'label' => 'Button Text', 'type' => 'text'],
                        ['name' => 'url', 'label' => 'Button URL', 'type' => 'text'],
                        ['name' => 'icon', 'label' => 'Button Icon', 'type' => 'icon'],
                    ]
                ],
                ['name' => 'more_text', 'label' => 'More Button Text', 'type' => 'text'],
            ],
        ],

        // ============================================================
        // HERO SECTION
        // ============================================================
        [
            'section_key' => 'hero',
            'name' => 'Hero Section',
            'description' => 'Main hero banner with headline, description, call-to-action buttons, and statistics.',
            'icon' => 'lucide:home',
            'sort_order' => 1,
            'default_title' => 'Fresh & Clean Laundry',
            'default_subtitle' => 'Every Time, On Time',
            'default_content' => [
                'badge' => '#1 Rated Laundry Service in Town',
                'description' => 'Experience premium laundry services with free pickup & delivery. We treat your clothes with care using eco-friendly products.',
                'hero_image' => null,
                'buttons' => [
                    ['text' => 'Schedule Pickup', 'url' => '#contact', 'icon' => 'lucide:calendar', 'is_transparent' => false],
                    ['text' => 'View Pricing', 'url' => '#pricing', 'icon' => '', 'is_transparent' => true],
                ],
                'floating_cards' => [
                    ['icon' => 'lucide:check', 'title' => 'Free Pickup', 'subtitle' => '& Delivery'],
                    ['icon' => 'lucide:clock', 'title' => 'Express', 'subtitle' => '24h Service'],
                ],
                'stats' => [
                    ['icon' => 'lucide:users', 'value' => '15K+', 'label' => 'Happy Customers'],
                    ['icon' => 'lucide:clipboard-check', 'value' => '50K+', 'label' => 'Orders Completed'],
                    ['icon' => 'lucide:smile', 'value' => '99%', 'label' => 'Satisfaction Rate'],
                    ['icon' => 'lucide:truck', 'value' => '24h', 'label' => 'Express Delivery']
                ],
            ],
            'content_schema' => [
                ['name' => 'badge', 'label' => 'Badge Text', 'type' => 'text'],
                ['name' => 'description', 'label' => 'Description', 'type' => 'textarea'],
                ['name' => 'hero_image', 'label' => 'Hero Image', 'type' => 'image'],
                [
                    'name' => 'buttons',
                    'label' => 'CTA Buttons',
                    'type' => 'repeater',
                    'fields' => [
                        ['name' => 'text', 'label' => 'Button Text', 'type' => 'text'],
                        ['name' => 'url', 'label' => 'Button URL', 'type' => 'text'],
                        ['name' => 'icon', 'label' => 'Button Icon', 'type' => 'icon'],
                        ['name' => 'is_transparent', 'label' => 'Transparent Style', 'type' => 'switch'],
                    ]
                ],
                [
                    'name' => 'floating_cards',
                    'label' => 'Floating Cards',
                    'type' => 'repeater',
                    'fields' => [
                        ['name' => 'icon', 'label' => 'Icon', 'type' => 'icon'],
                        ['name' => 'title', 'label' => 'Title', 'type' => 'text'],
                        ['name' => 'subtitle', 'label' => 'Subtitle', 'type' => 'text'],
                    ]
                ],
                [
                    'name' => 'stats',
                    'label' => 'Statistics',
                    'type' => 'repeater',
                    'fields' => [
                        ['name' => 'icon', 'label' => 'Icon', 'type' => 'icon'],
                        ['name' => 'value', 'label' => 'Value', 'type' => 'text'],
                        ['name' => 'label', 'label' => 'Label', 'type' => 'text'],
                    ]
                ],
            ],
        ],

        // ============================================================
        // FEATURES SECTION
        // ============================================================
        [
            'section_key' => 'features',
            'name' => 'Features Section',
            'description' => 'Showcase key features with icons and descriptions.',
            'icon' => 'lucide:star',
            'sort_order' => 2,
            'is_white_background' => 1,
            'default_title' => 'Why Choose Us',
            'default_subtitle' => 'Features that set us apart',
            'default_content' => [
                'items' => [
                    ['icon' => 'lucide:leaf', 'title' => 'Eco-Friendly', 'description' => '100% biodegradable detergents.'],
                    ['icon' => 'lucide:clock', 'title' => 'On-Time Delivery', 'description' => 'Guaranteed delivery within promised timeframe.'],
                    ['icon' => 'lucide:shield-check', 'title' => 'Fully Insured', 'description' => 'Your garments are protected.'],
                    ['icon' => 'lucide:heart', 'title' => 'Care & Quality', 'description' => 'Every item treated with attention.']
                ],
            ],
            'content_schema' => [
                [
                    'name' => 'items',
                    'label' => 'Feature Items',
                    'type' => 'repeater',
                    'fields' => [
                        ['name' => 'icon', 'label' => 'Icon', 'type' => 'icon'],
                        ['name' => 'title', 'label' => 'Title', 'type' => 'text'],
                        ['name' => 'description', 'label' => 'Description', 'type' => 'textarea'],
                    ]
                ],
            ],
        ],

        // ============================================================
        // SERVICES SECTION
        // ============================================================
        [
            'section_key' => 'services',
            'name' => 'Services Section',
            'description' => 'Display available services with icons, descriptions, pricing, and features.',
            'icon' => 'lucide:grid-2x2',
            'sort_order' => 3,
            'default_title' => 'Professional Laundry Services',
            'default_subtitle' => "From everyday laundry to delicate dry cleaning, we've got all your garment care needs covered.",
            'default_content' => [
                'badge' => 'Our Services',
                'items' => [
                    [
                        'icon' => 'lucide:shirt',
                        'title' => 'Wash & Fold',
                        'description' => 'Professional washing, drying, and folding service for your everyday clothes.',
                        'price' => 'From $2.50/lb',
                        'features' => [
                            ['text' => 'Same-day service available'],
                            ['text' => 'Eco-friendly detergents'],
                            ['text' => 'Fabric softener included'],
                        ],
                        'button_text' => 'Learn More',
                        'button_url' => '#contact',
                        'button_icon' => 'lucide:arrow-right',
                    ],
                    [
                        'icon' => 'lucide:sparkles',
                        'title' => 'Dry Cleaning',
                        'description' => 'Expert care for your delicate and special garments that need extra attention.',
                        'price' => 'From $8.99/item',
                        'features' => [
                            ['text' => 'Suits & formal wear'],
                            ['text' => 'Delicate fabrics'],
                            ['text' => 'Stain treatment included'],
                        ],
                        'button_text' => 'Learn More',
                        'button_url' => '#contact',
                        'button_icon' => 'lucide:arrow-right',
                    ],
                    [
                        'icon' => 'lucide:wind',
                        'title' => 'Press & Iron',
                        'description' => 'Professional pressing and ironing for a crisp, polished look.',
                        'price' => 'From $3.50/item',
                        'features' => [
                            ['text' => 'Steam pressing'],
                            ['text' => 'Hand finishing'],
                            ['text' => 'Ready to wear'],
                        ],
                        'button_text' => 'Learn More',
                        'button_url' => '#contact',
                        'button_icon' => 'lucide:arrow-right',
                    ],
                    [
                        'icon' => 'lucide:bed-double',
                        'title' => 'Bedding & Linens',
                        'description' => 'Fresh, clean bedding and household linens for maximum comfort.',
                        'price' => 'From $15.99/set',
                        'features' => [
                            ['text' => 'Comforters & duvets'],
                            ['text' => 'Sheets & pillowcases'],
                            ['text' => 'Allergen removal'],
                        ],
                        'button_text' => 'Learn More',
                        'button_url' => '#contact',
                        'button_icon' => 'lucide:arrow-right',
                    ],
                    [
                        'icon' => 'lucide:gem',
                        'title' => 'Premium Care',
                        'description' => 'Specialized treatment for luxury fabrics and designer pieces.',
                        'price' => 'Custom pricing',
                        'features' => [
                            ['text' => 'Designer labels'],
                            ['text' => 'Silk & cashmere'],
                            ['text' => 'Hand wash only items'],
                        ],
                        'button_text' => 'Learn More',
                        'button_url' => '#contact',
                        'button_icon' => 'lucide:arrow-right',
                    ],
                    [
                        'icon' => 'lucide:zap',
                        'title' => 'Express Service',
                        'description' => 'Urgent cleaning with quick turnaround when you need it fast.',
                        'price' => '+50% rush fee',
                        'features' => [
                            ['text' => '2-hour turnaround'],
                            ['text' => 'Priority handling'],
                            ['text' => 'Delivery included'],
                        ],
                        'button_text' => 'Learn More',
                        'button_url' => '#contact',
                        'button_icon' => 'lucide:arrow-right',
                    ],
                ],
            ],
            'content_schema' => [
                ['name' => 'badge', 'label' => 'Badge Text', 'type' => 'text'],
                [
                    'name' => 'items',
                    'label' => 'Service Items',
                    'type' => 'repeater',
                    'fields' => [
                        ['name' => 'icon', 'label' => 'Icon', 'type' => 'icon'],
                        ['name' => 'title', 'label' => 'Title', 'type' => 'text'],
                        ['name' => 'description', 'label' => 'Description', 'type' => 'textarea'],
                        ['name' => 'price', 'label' => 'Price', 'type' => 'text'],
                        [
                            'name' => 'features',
                            'label' => 'Features',
                            'type' => 'nested_repeater',
                            'fields' => [
                                ['name' => 'text', 'label' => 'Feature Text', 'type' => 'text'],
                            ],
                        ],
                        ['name' => 'button_text', 'label' => 'Button Text', 'type' => 'text'],
                        ['name' => 'button_url', 'label' => 'Button URL', 'type' => 'text'],
                        ['name' => 'button_icon', 'label' => 'Button Icon', 'type' => 'icon'],
                    ],
                ],
            ],
        ],

        // ============================================================
        // HOW IT WORKS SECTION
        // ============================================================
        [
            'section_key' => 'how_it_works',
            'name' => 'How It Works',
            'description' => 'Step-by-step process explanation with numbered steps.',
            'icon' => 'lucide:list',
            'sort_order' => 4,
            'is_white_background' => 1,
            'default_title' => 'Simple 4-Step Process',
            'default_subtitle' => 'Getting your laundry done has never been easier.',
            'default_content' => [
                'badge' => 'How It Works',
                'items' => [
                    ['step' => '01', 'title' => 'Schedule Pickup', 'description' => 'Book online or call us.', 'icon' => 'lucide:calendar'],
                    ['step' => '02', 'title' => 'We Collect', 'description' => 'Our driver arrives at your doorstep.', 'icon' => 'lucide:truck'],
                    ['step' => '03', 'title' => 'Expert Cleaning', 'description' => 'Your clothes are cleaned with care.', 'icon' => 'lucide:sparkles'],
                    ['step' => '04', 'title' => 'Delivery', 'description' => 'Fresh, clean laundry delivered back to you.', 'icon' => 'lucide:home']
                ],
            ],
            'content_schema' => [
                ['name' => 'badge', 'label' => 'Badge Text', 'type' => 'text'],
                [
                    'name' => 'items',
                    'label' => 'Process Steps',
                    'type' => 'repeater',
                    'fields' => [
                        ['name' => 'step', 'label' => 'Step Number', 'type' => 'text'],
                        ['name' => 'title', 'label' => 'Title', 'type' => 'text'],
                        ['name' => 'description', 'label' => 'Description', 'type' => 'textarea'],
                        ['name' => 'icon', 'label' => 'Icon', 'type' => 'icon'],
                    ]
                ],
            ],
        ],

        // ============================================================
        // PRICING SECTION
        // ============================================================
        [
            'section_key' => 'pricing',
            'name' => 'Pricing Plans',
            'description' => 'Display pricing plans with features comparison.',
            'icon' => 'lucide:dollar-sign',
            'sort_order' => 5,
            'default_title' => 'Choose Your Perfect Plan',
            'default_subtitle' => 'Flexible plans designed to fit your lifestyle.',
            'default_content' => [
                'badge' => 'Pricing Plans',
                'currency_symbol' => '$',
                'popular_badge' => 'Most Popular',
                'cta_button' => 'Get Started',
                'cta_button_url' => '#contact',
                'items' => [
                    [
                        'name' => 'Basic',
                        'price' => '29',
                        'period' => 'per month',
                        'description' => 'Perfect for individuals',
                        'features' => [
                            ['icon' => 'lucide:scale', 'text' => '15 lbs of laundry', 'is_included' => true],
                            ['icon' => 'lucide:sparkles', 'text' => 'Wash & fold service', 'is_included' => true],
                            ['icon' => 'lucide:truck', 'text' => 'Free pickup & delivery', 'is_included' => true],
                            ['icon' => 'lucide:clock', 'text' => '48-hour turnaround', 'is_included' => true],
                            ['icon' => 'lucide:flask-conical', 'text' => 'Standard detergents', 'is_included' => true],
                            ['icon' => 'lucide:leaf', 'text' => 'Premium eco detergents', 'is_included' => false],
                            ['icon' => 'lucide:zap', 'text' => 'Same-day turnaround', 'is_included' => false],
                        ],
                        'popular' => false,
                    ],
                    [
                        'name' => 'Family',
                        'price' => '79',
                        'period' => 'per month',
                        'description' => 'Best for families',
                        'features' => [
                            ['icon' => 'lucide:scale', 'text' => '50 lbs of laundry', 'is_included' => true],
                            ['icon' => 'lucide:sparkles', 'text' => 'Wash, fold & iron', 'is_included' => true],
                            ['icon' => 'lucide:truck', 'text' => 'Free pickup & delivery', 'is_included' => true],
                            ['icon' => 'lucide:clock', 'text' => '24-hour turnaround', 'is_included' => true],
                            ['icon' => 'lucide:leaf', 'text' => 'Premium eco detergents', 'is_included' => true],
                            ['icon' => 'lucide:scissors', 'text' => '2 dry clean items/month', 'is_included' => true],
                            ['icon' => 'lucide:zap', 'text' => 'Same-day turnaround', 'is_included' => false],
                        ],
                        'popular' => true,
                    ],
                    [
                        'name' => 'Business',
                        'price' => '199',
                        'period' => 'per month',
                        'description' => 'For businesses & hotels',
                        'features' => [
                            ['icon' => 'lucide:infinity', 'text' => 'Unlimited laundry', 'is_included' => true],
                            ['icon' => 'lucide:badge-check', 'text' => 'All services included', 'is_included' => true],
                            ['icon' => 'lucide:calendar-days', 'text' => 'Daily pickup available', 'is_included' => true],
                            ['icon' => 'lucide:zap', 'text' => 'Same-day turnaround', 'is_included' => true],
                            ['icon' => 'lucide:user-circle', 'text' => 'Dedicated account manager', 'is_included' => true],
                            ['icon' => 'lucide:phone', 'text' => 'Priority support', 'is_included' => true],
                            ['icon' => 'lucide:paintbrush', 'text' => 'Custom branding', 'is_included' => true],
                        ],
                        'popular' => false,
                    ],
                ],
            ],
            'content_schema' => [
                ['name' => 'badge', 'label' => 'Badge Text', 'type' => 'text'],
                ['name' => 'currency_symbol', 'label' => 'Currency Symbol', 'type' => 'text'],
                ['name' => 'popular_badge', 'label' => 'Popular Badge Text', 'type' => 'text'],
                ['name' => 'cta_button', 'label' => 'CTA Button Text', 'type' => 'text'],
                ['name' => 'cta_button_url', 'label' => 'CTA Button URL', 'type' => 'text'],
                [
                    'name' => 'items',
                    'label' => 'Pricing Plans',
                    'type' => 'repeater',
                    'fields' => [
                        ['name' => 'name', 'label' => 'Plan Name', 'type' => 'text'],
                        ['name' => 'price', 'label' => 'Price', 'type' => 'text'],
                        ['name' => 'period', 'label' => 'Period', 'type' => 'text'],
                        ['name' => 'description', 'label' => 'Description', 'type' => 'text'],
                        [
                            'name' => 'features',
                            'label' => 'Features',
                            'type' => 'nested_repeater',
                            'fields' => [
                                ['name' => 'icon', 'label' => 'Icon', 'type' => 'icon'],
                                ['name' => 'text', 'label' => 'Feature Text', 'type' => 'text'],
                                ['name' => 'is_included', 'label' => 'Included?', 'type' => 'switch'],
                            ],
                        ],
                        ['name' => 'popular', 'label' => 'Is Popular?', 'type' => 'switch'],
                    ],
                ],
            ],
        ],

        // ============================================================
        // GALLERY SECTION
        // ============================================================
        [
            'section_key' => 'gallery',
            'name' => 'Gallery Section',
            'description' => 'Image gallery to showcase facility, work, or portfolio.',
            'icon' => 'lucide:image',
            'sort_order' => 6,
            'is_white_background' => 1,
            'default_title' => 'Our Facility & Work',
            'default_subtitle' => 'Take a look at our state-of-the-art facility.',
            'default_content' => [
                'badge' => 'Gallery',
                'items' => [],
            ],
            'content_schema' => [
                ['name' => 'badge', 'label' => 'Badge Text', 'type' => 'text'],
                [
                    'name' => 'items',
                    'label' => 'Gallery Images',
                    'type' => 'repeater',
                    'fields' => [
                        ['name' => 'image', 'label' => 'Image', 'type' => 'image'],
                        ['name' => 'alt', 'label' => 'Alt Text', 'type' => 'text'],
                    ]
                ],
            ],
        ],

        // ============================================================
        // TESTIMONIALS SECTION
        // ============================================================
        [
            'section_key' => 'testimonials',
            'name' => 'Testimonials',
            'description' => 'Customer reviews and testimonials with ratings.',
            'icon' => 'lucide:message-square',
            'sort_order' => 7,
            'default_title' => 'What Our Customers Say',
            'default_subtitle' => "Don't just take our word for it.",
            'default_content' => [
                'badge' => 'Testimonials',
                'items' => [
                    [
                        'name' => 'Sarah Johnson',
                        'role' => 'Working Professional',
                        'avatar' => null,
                        'rating' => 5,
                        'text' => 'SparkleWash has been a lifesaver! As a busy professional, I no longer worry about laundry.'
                    ],
                    [
                        'name' => 'Michael Chen',
                        'role' => 'Restaurant Owner',
                        'avatar' => null,
                        'rating' => 5,
                        'text' => 'We use SparkleWash for all our restaurant linens. The quality is exceptional.'
                    ],
                    [
                        'name' => 'Emily Rodriguez',
                        'role' => 'Mother of Three',
                        'avatar' => null,
                        'rating' => 5,
                        'text' => 'With three kids, laundry used to be never-ending. Now SparkleWash handles it all.'
                    ],
                    [
                        'name' => 'David Park',
                        'role' => 'Hotel Manager',
                        'avatar' => null,
                        'rating' => 5,
                        'text' => 'Our hotel has partnered with SparkleWash for over 2 years. Their reliability is exceptional.'
                    ]
                ],
            ],
            'content_schema' => [
                ['name' => 'badge', 'label' => 'Badge Text', 'type' => 'text'],
                [
                    'name' => 'items',
                    'label' => 'Testimonials',
                    'type' => 'repeater',
                    'fields' => [
                        ['name' => 'avatar', 'label' => 'Avatar', 'type' => 'image'],
                        ['name' => 'name', 'label' => 'Customer Name', 'type' => 'text'],
                        ['name' => 'role', 'label' => 'Role/Title', 'type' => 'text'],
                        ['name' => 'rating', 'label' => 'Rating (1-5)', 'type' => 'number'],
                        ['name' => 'text', 'label' => 'Testimonial Text', 'type' => 'textarea'],
                    ]
                ],
            ],
        ],

        // ============================================================
        // FAQ SECTION
        // ============================================================
        [
            'section_key' => 'faq',
            'name' => 'FAQ Section',
            'description' => 'Frequently asked questions with expandable answers.',
            'icon' => 'lucide:help-circle',
            'sort_order' => 8,
            'is_white_background' => 1,
            'default_title' => 'Frequently Asked Questions',
            'default_subtitle' => 'Find answers to common questions.',
            'default_content' => [
                'badge' => 'FAQ',
                'items' => [
                    [
                        'question' => 'How does the pickup and delivery work?',
                        'answer' => 'Simply schedule a pickup through our website or app. Our driver will arrive at your chosen time slot.'
                    ],
                    [
                        'question' => 'What if my clothes get damaged?',
                        'answer' => 'We take utmost care of your garments. In the rare case of damage, we have comprehensive insurance.'
                    ],
                    [
                        'question' => 'Do you use eco-friendly products?',
                        'answer' => 'Yes! We use biodegradable, eco-friendly detergents that are gentle on both your clothes and the environment.'
                    ],
                    [
                        'question' => 'What areas do you serve?',
                        'answer' => 'We currently serve the entire Washville metropolitan area including downtown and suburbs.'
                    ],
                    [
                        'question' => 'Can I specify washing instructions?',
                        'answer' => 'Absolutely! You can add special instructions for each order.'
                    ],
                    [
                        'question' => 'What payment methods do you accept?',
                        'answer' => 'We accept all major credit cards, debit cards, and digital wallets.'
                    ]
                ],
            ],
            'content_schema' => [
                ['name' => 'badge', 'label' => 'Badge Text', 'type' => 'text'],
                [
                    'name' => 'items',
                    'label' => 'FAQ Items',
                    'type' => 'repeater',
                    'fields' => [
                        ['name' => 'question', 'label' => 'Question', 'type' => 'text'],
                        ['name' => 'answer', 'label' => 'Answer', 'type' => 'textarea'],
                    ]
                ],
            ],
        ],

        // ============================================================
        // CONTACT SECTION
        // ============================================================
        [
            'section_key' => 'contact',
            'name' => 'Contact Section',
            'description' => 'Contact information with Google Maps display.',
            'icon' => 'lucide:phone',
            'sort_order' => 9,
            'default_title' => 'Get In Touch',
            'default_subtitle' => "Have questions? We're here to help. Reach out to us through any of the channels below.",
            'default_content' => [
                'badge' => 'Contact Us',
                'info_phone_label' => 'Phone',
                'info_email_label' => 'Email',
                'info_address_label' => 'Address',
                'info_hours_label' => 'Business Hours',
                'info_follow_us_label' => 'Follow Us',
                'google_map_url' => 'https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3560.42714994861!2d75.79407859999999!3d26.8263631!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x396dcbd249344835%3A0x3672105f64439583!2sCodraj%20Infotech%20Private%20Limited!5e0!3m2!1sen!2sin!4v1768503201556!5m2!1sen!2sin',
                'google_map_link_url' => 'https://maps.app.goo.gl/21q8ufi5MUxQj8vo8',
                'open_in_maps_text' => 'Open in Google Maps',
            ],
            'content_schema' => [
                ['name' => 'badge', 'label' => 'Badge Text', 'type' => 'text'],
                ['name' => 'info_phone_label', 'label' => 'Phone Label', 'type' => 'text'],
                ['name' => 'info_email_label', 'label' => 'Email Label', 'type' => 'text'],
                ['name' => 'info_address_label', 'label' => 'Address Label', 'type' => 'text'],
                ['name' => 'info_hours_label', 'label' => 'Hours Label', 'type' => 'text'],
                ['name' => 'info_follow_us_label', 'label' => 'Follow Us Label', 'type' => 'text'],
                ['name' => 'google_map_url', 'label' => 'Google Map Embed URL', 'type' => 'text'],
                ['name' => 'google_map_link_url', 'label' => 'Google Map Link URL', 'type' => 'text'],
                ['name' => 'open_in_maps_text', 'label' => 'Open in Maps Link Text', 'type' => 'text'],
            ],
        ],

        // ============================================================
        // CTA SECTION
        // ============================================================
        [
            'section_key' => 'cta',
            'name' => 'Call to Action',
            'description' => 'Prominent call-to-action section with buttons.',
            'icon' => 'lucide:rocket',
            'sort_order' => 10,
            'default_title' => 'Ready to Get Started?',
            'default_subtitle' => 'Join thousands of happy customers.',
            'default_content' => [
                'primary_button' => 'Schedule Your First Pickup',
                'secondary_button' => 'Call Us Now',
                'background_image' => null,
            ],
            'content_schema' => [
                ['name' => 'primary_button', 'label' => 'Primary Button Text', 'type' => 'text'],
                ['name' => 'secondary_button', 'label' => 'Secondary Button Text', 'type' => 'text'],
                ['name' => 'background_image', 'label' => 'Background Image', 'type' => 'image'],
            ],
        ],

        // ============================================================
        // STATS SECTION
        // ============================================================
        [
            'section_key' => 'stats',
            'name' => 'Statistics',
            'description' => 'Display key numbers and achievements.',
            'icon' => 'lucide:bar-chart',
            'sort_order' => 12,
            'default_title' => 'Our Achievements',
            'default_subtitle' => 'Numbers that speak for themselves',
            'default_content' => [
                'badge' => 'Statistics',
                'items' => [
                    ['value' => '15000+', 'label' => 'Happy Customers', 'icon' => 'lucide:users'],
                    ['value' => '50000+', 'label' => 'Orders Completed', 'icon' => 'lucide:box'],
                    ['value' => '99%', 'label' => 'Satisfaction Rate', 'icon' => 'lucide:star'],
                    ['value' => '24h', 'label' => 'Express Delivery', 'icon' => 'lucide:clock']
                ],
            ],
            'content_schema' => [
                ['name' => 'badge', 'label' => 'Badge Text', 'type' => 'text'],
                [
                    'name' => 'items',
                    'label' => 'Statistics Items',
                    'type' => 'repeater',
                    'fields' => [
                        ['name' => 'value', 'label' => 'Value', 'type' => 'text'],
                        ['name' => 'label', 'label' => 'Label', 'type' => 'text'],
                        ['name' => 'icon', 'label' => 'Icon', 'type' => 'icon'],
                    ]
                ],
            ],
        ],

        // ============================================================
        // ABOUT US SECTION
        // ============================================================
        [
            'section_key' => 'about',
            'name' => 'About Us Section',
            'description' => 'Company story, mission, and values with image.',
            'icon' => 'lucide:info',
            'sort_order' => 13,
            'is_white_background' => 1,
            'default_title' => 'About Our Company',
            'default_subtitle' => 'A legacy of quality and trust',
            'default_content' => [
                'badge' => 'About Us',
                'story' => 'Founded in 2010, we started with a simple mission: to provide exceptional laundry services that save our customers time while delivering impeccable quality. What began as a small family operation has grown into a trusted name serving thousands of happy customers.',
                'mission_title' => 'Our Mission',
                'mission' => 'To revolutionize the laundry industry by combining cutting-edge technology with personalized service, making garment care effortless and eco-friendly.',
                'vision_title' => 'Our Vision',
                'vision' => 'To be the most trusted and innovative laundry service provider, setting the standard for quality, sustainability, and customer satisfaction.',
                'image' => null,
                'image_alt' => 'About our company',
                'years_experience' => '15+',
                'years_label' => 'Years of Excellence',
                'values' => [
                    ['icon' => 'lucide:heart', 'title' => 'Customer First', 'description' => 'Your satisfaction is our top priority'],
                    ['icon' => 'lucide:leaf', 'title' => 'Eco-Conscious', 'description' => 'Sustainable practices in everything we do'],
                    ['icon' => 'lucide:shield-check', 'title' => 'Quality Assured', 'description' => 'Meticulous attention to every detail'],
                ],
            ],
            'content_schema' => [
                ['name' => 'badge', 'label' => 'Badge Text', 'type' => 'text'],
                ['name' => 'story', 'label' => 'Company Story', 'type' => 'textarea'],
                ['name' => 'mission_title', 'label' => 'Mission Title', 'type' => 'text'],
                ['name' => 'mission', 'label' => 'Mission Statement', 'type' => 'textarea'],
                ['name' => 'vision_title', 'label' => 'Vision Title', 'type' => 'text'],
                ['name' => 'vision', 'label' => 'Vision Statement', 'type' => 'textarea'],
                ['name' => 'image', 'label' => 'About Image', 'type' => 'image'],
                ['name' => 'image_alt', 'label' => 'Image Alt Text', 'type' => 'text'],
                ['name' => 'years_experience', 'label' => 'Years of Experience', 'type' => 'text'],
                ['name' => 'years_label', 'label' => 'Years Label', 'type' => 'text'],
                [
                    'name' => 'values',
                    'label' => 'Core Values',
                    'type' => 'repeater',
                    'fields' => [
                        ['name' => 'icon', 'label' => 'Icon', 'type' => 'icon'],
                        ['name' => 'title', 'label' => 'Value Title', 'type' => 'text'],
                        ['name' => 'description', 'label' => 'Value Description', 'type' => 'text'],
                    ]
                ],
            ],
        ],

        // ============================================================
        // TEAM SECTION
        // ============================================================
        [
            'section_key' => 'team',
            'name' => 'Team Section',
            'description' => 'Showcase team members with photos and roles.',
            'icon' => 'lucide:users',
            'sort_order' => 14,
            'default_title' => 'Meet Our Team',
            'default_subtitle' => 'The dedicated professionals behind our service',
            'default_content' => [
                'badge' => 'Our Team',
                'items' => [
                    [
                        'name' => 'John Smith',
                        'role' => 'Founder & CEO',
                        'image' => null,
                        'bio' => 'With 20 years in the industry, John founded the company with a vision for excellence.',
                        'social_links' => [
                            ['icon' => 'mdi:linkedin', 'url' => '#'],
                            ['icon' => 'mdi:twitter', 'url' => '#'],
                            ['icon' => 'mdi:email', 'url' => 'mailto:john@example.com'],
                        ],
                    ],
                    [
                        'name' => 'Sarah Williams',
                        'role' => 'Operations Manager',
                        'image' => null,
                        'bio' => 'Sarah ensures every order is processed with precision and care.',
                        'social_links' => [
                            ['icon' => 'mdi:linkedin', 'url' => '#'],
                            ['icon' => 'mdi:twitter', 'url' => '#'],
                        ],
                    ],
                    [
                        'name' => 'Mike Johnson',
                        'role' => 'Head of Quality',
                        'image' => null,
                        'bio' => 'Mike leads our quality assurance team, maintaining our high standards.',
                        'social_links' => [
                            ['icon' => 'mdi:linkedin', 'url' => '#'],
                            ['icon' => 'mdi:email', 'url' => 'mailto:mike@example.com'],
                        ],
                    ],
                    [
                        'name' => 'Emily Chen',
                        'role' => 'Customer Success Lead',
                        'image' => null,
                        'bio' => 'Emily and her team ensure every customer has an exceptional experience.',
                        'social_links' => [
                            ['icon' => 'mdi:linkedin', 'url' => '#'],
                            ['icon' => 'mdi:twitter', 'url' => '#'],
                            ['icon' => 'mdi:instagram', 'url' => '#'],
                        ],
                    ],
                ],
            ],
            'content_schema' => [
                ['name' => 'badge', 'label' => 'Badge Text', 'type' => 'text'],
                [
                    'name' => 'items',
                    'label' => 'Team Members',
                    'type' => 'repeater',
                    'fields' => [
                        ['name' => 'image', 'label' => 'Photo', 'type' => 'image'],
                        ['name' => 'name', 'label' => 'Name', 'type' => 'text'],
                        ['name' => 'role', 'label' => 'Role/Position', 'type' => 'text'],
                        ['name' => 'bio', 'label' => 'Short Bio', 'type' => 'textarea'],
                        [
                            'name' => 'social_links',
                            'label' => 'Social Links',
                            'type' => 'nested_repeater',
                            'fields' => [
                                ['name' => 'icon', 'label' => 'Icon', 'type' => 'icon'],
                                ['name' => 'url', 'label' => 'URL', 'type' => 'text'],
                            ]
                        ],
                    ]
                ],
            ],
        ],

        // ============================================================
        // PARTNERS/CLIENTS LOGOS SECTION
        // ============================================================
        [
            'section_key' => 'partners',
            'name' => 'Partners & Clients',
            'description' => 'Display partner or client logos for trust building.',
            'icon' => 'lucide:building-2',
            'sort_order' => 15,
            'is_white_background' => 1,
            'default_title' => 'Trusted By Industry Leaders',
            'default_subtitle' => 'We are proud to serve these amazing companies',
            'default_content' => [
                'badge' => 'Our Partners',
                'show_title' => true,
                'grayscale' => true,
                'items' => [
                    ['name' => 'Marriott Hotels', 'logo' => null, 'url' => ''],
                    ['name' => 'Hilton', 'logo' => null, 'url' => ''],
                    ['name' => 'Airbnb', 'logo' => null, 'url' => ''],
                    ['name' => 'WeWork', 'logo' => null, 'url' => ''],
                    ['name' => 'Regus', 'logo' => null, 'url' => ''],
                    ['name' => 'IHG Hotels', 'logo' => null, 'url' => ''],
                ],
            ],
            'content_schema' => [
                ['name' => 'badge', 'label' => 'Badge Text', 'type' => 'text'],
                ['name' => 'show_title', 'label' => 'Show Title & Subtitle', 'type' => 'switch'],
                ['name' => 'grayscale', 'label' => 'Grayscale Logos', 'type' => 'switch'],
                [
                    'name' => 'items',
                    'label' => 'Partner Logos',
                    'type' => 'repeater',
                    'fields' => [
                        ['name' => 'logo', 'label' => 'Logo Image', 'type' => 'image'],
                        ['name' => 'name', 'label' => 'Company Name', 'type' => 'text'],
                        ['name' => 'url', 'label' => 'Website URL (optional)', 'type' => 'text'],
                    ]
                ],
            ],
        ],

        // ============================================================
        // VIDEO SECTION
        // ============================================================
        [
            'section_key' => 'video',
            'name' => 'Video Section',
            'description' => 'Embed promotional or explainer video with overlay.',
            'icon' => 'lucide:play-circle',
            'sort_order' => 16,
            'default_title' => 'See How We Work',
            'default_subtitle' => 'Watch our process in action',
            'default_content' => [
                'badge' => 'Watch Video',
                'video_url' => 'https://www.youtube.com/watch?v=dQw4w9WgXcQ',
                'video_type' => 'youtube',
                'thumbnail' => null,
                'play_button_text' => 'Watch Now',
                'duration' => '2:30',
                'autoplay' => false,
                'overlay_text' => 'Experience the difference',
                'overlay_description' => 'Our state-of-the-art facility and dedicated team ensure your garments receive the best care possible.',
            ],
            'content_schema' => [
                ['name' => 'badge', 'label' => 'Badge Text', 'type' => 'text'],
                ['name' => 'video_url', 'label' => 'Video URL (YouTube/Vimeo)', 'type' => 'text'],
                [
                    'name' => 'video_type',
                    'label' => 'Video Type',
                    'type' => 'select',
                    'options' => [
                        ['value' => 'youtube', 'label' => 'YouTube'],
                        ['value' => 'vimeo', 'label' => 'Vimeo'],
                        ['value' => 'custom', 'label' => 'Custom Video URL'],
                    ]
                ],
                ['name' => 'thumbnail', 'label' => 'Video Thumbnail', 'type' => 'image'],
                ['name' => 'play_button_text', 'label' => 'Play Button Text', 'type' => 'text'],
                ['name' => 'duration', 'label' => 'Video Duration', 'type' => 'text'],
                ['name' => 'autoplay', 'label' => 'Autoplay on Open', 'type' => 'switch'],
                ['name' => 'overlay_text', 'label' => 'Overlay Heading', 'type' => 'text'],
                ['name' => 'overlay_description', 'label' => 'Overlay Description', 'type' => 'textarea'],
            ],
        ],

        // ============================================================
        // DOWNLOAD APP SECTION
        // ============================================================
        [
            'section_key' => 'app_download',
            'name' => 'Download App Section',
            'description' => 'Promote mobile app with download links.',
            'icon' => 'lucide:smartphone',
            'sort_order' => 17,
            'is_white_background' => 1,
            'default_title' => 'Get Our Mobile App',
            'default_subtitle' => 'Schedule pickups, track orders, and manage your account on the go',
            'default_content' => [
                'badge' => 'Mobile App',
                'description' => 'Download our free app and enjoy seamless laundry services at your fingertips. Available for iOS and Android devices.',
                'cta_buttons' => [
                    ['icon' => 'mdi:apple', 'url' => 'https://apps.apple.com', 'text_top' => 'Download on the', 'text_main' => 'App Store'],
                    ['icon' => 'mdi:google-play', 'url' => 'https://play.google.com', 'text_top' => 'Get it on', 'text_main' => 'Google Play'],
                ],
                'phone_mockup' => null,
                'features' => [
                    ['icon' => 'lucide:calendar', 'text' => 'Easy scheduling', 'description' => 'Book services in just a few taps'],
                    ['icon' => 'lucide:map-pin', 'text' => 'Real-time tracking', 'description' => 'Track your order status live'],
                    ['icon' => 'lucide:bell', 'text' => 'Push notifications', 'description' => 'Stay updated with instant alerts'],
                    ['icon' => 'lucide:credit-card', 'text' => 'Secure payments', 'description' => 'Multiple payment options available'],
                ],
                'qr_code' => null,
                'qr_label' => 'Scan to Download',
                'qr_description' => 'Point your camera at the QR code to download the app instantly',
                'app_stats' => [
                    ['icon' => 'lucide:download', 'value' => '500K+', 'label' => 'Downloads'],
                    ['icon' => 'lucide:star', 'value' => '4.8', 'label' => 'App Rating'],
                    ['icon' => 'lucide:users', 'value' => '100K+', 'label' => 'Happy Users'],
                ],
                'trusted_users' => [
                    'enabled' => true,
                    'title' => 'Trusted by %count% users',
                    'subtitle' => 'Join thousands of satisfied customers',
                    'avatars' => [
                        ['image' => null, 'name' => 'User 1'],
                        ['image' => null, 'name' => 'User 2'],
                        ['image' => null, 'name' => 'User 3'],
                        ['image' => null, 'name' => 'User 4'],
                        ['image' => null, 'name' => 'User 5'],
                    ],
                ],
                'app_image' => null,
            ],
            'content_schema' => [
                ['name' => 'badge', 'label' => 'Badge Text', 'type' => 'text'],
                ['name' => 'description', 'label' => 'Description', 'type' => 'textarea'],
                ['name' => 'app_image', 'label' => 'App Mockup Image', 'type' => 'image'],
                [
                    'name' => 'cta_buttons',
                    'label' => 'CTA Buttons',
                    'type' => 'repeater',
                    'fields' => [
                        ['name' => 'icon', 'label' => 'Icon', 'type' => 'icon'],
                        ['name' => 'url', 'label' => 'URL', 'type' => 'text'],
                        ['name' => 'text_top', 'label' => 'Top Text', 'type' => 'text'],
                        ['name' => 'text_main', 'label' => 'Main Text', 'type' => 'text'],
                    ]
                ],
                [
                    'name' => 'features',
                    'label' => 'App Features',
                    'type' => 'repeater',
                    'fields' => [
                        ['name' => 'icon', 'label' => 'Icon', 'type' => 'icon'],
                        ['name' => 'text', 'label' => 'Feature Title', 'type' => 'text'],
                        ['name' => 'description', 'label' => 'Feature Description', 'type' => 'text'],
                    ]
                ],
                [
                    'name' => 'app_stats',
                    'label' => 'App Stats',
                    'type' => 'repeater',
                    'fields' => [
                        ['name' => 'icon', 'label' => 'Icon', 'type' => 'icon'],
                        ['name' => 'value', 'label' => 'Value', 'type' => 'text'],
                        ['name' => 'label', 'label' => 'Label', 'type' => 'text'],
                    ]
                ],
                [
                    'name' => 'trusted_users',
                    'label' => 'Trusted Users',
                    'type' => 'group_with_repeater',
                    'fields' => [
                        ['name' => 'enabled', 'label' => 'Enable Section', 'type' => 'switch'],
                        ['name' => 'title', 'label' => 'Title', 'type' => 'text'],
                        ['name' => 'subtitle', 'label' => 'Subtitle', 'type' => 'text'],
                        [
                            'name' => 'avatars',
                            'label' => 'User Avatars',
                            'type' => 'repeater',
                            'fields' => [
                                ['name' => 'image', 'label' => 'Avatar Image', 'type' => 'image'],
                                ['name' => 'name', 'label' => 'User Name', 'type' => 'text'],
                            ]
                        ],
                    ]
                ],
                ['name' => 'qr_code', 'label' => 'QR Code Image', 'type' => 'image'],
                ['name' => 'qr_label', 'label' => 'QR Code Label', 'type' => 'text'],
                ['name' => 'qr_description', 'label' => 'QR Code Description', 'type' => 'text'],
            ],
        ],

        // ============================================================
        // AWARDS & CERTIFICATIONS SECTION
        // ============================================================
        [
            'section_key' => 'awards',
            'name' => 'Awards & Certifications',
            'description' => 'Display awards, certifications, and achievements.',
            'icon' => 'lucide:trophy',
            'sort_order' => 20,
            'default_title' => 'Awards & Recognition',
            'default_subtitle' => 'Our commitment to excellence has been recognized',
            'default_content' => [
                'badge' => 'Recognition',
                'description' => 'We are proud to be recognized for our commitment to quality, sustainability, and customer service.',
                'items' => [
                    [
                        'title' => 'Best Laundry Service 2024',
                        'organization' => 'City Business Awards',
                        'year' => '2024',
                        'image' => null,
                        'description' => 'Recognized for outstanding service quality',
                    ],
                    [
                        'title' => 'Green Business Certification',
                        'organization' => 'Environmental Council',
                        'year' => '2023',
                        'image' => null,
                        'description' => 'Certified for eco-friendly practices',
                    ],
                    [
                        'title' => 'Customer Choice Award',
                        'organization' => 'Consumer Reports',
                        'year' => '2023',
                        'image' => null,
                        'description' => 'Voted #1 by customers',
                    ],
                    [
                        'title' => 'ISO 9001 Certified',
                        'organization' => 'ISO',
                        'year' => '2022',
                        'image' => null,
                        'description' => 'Quality management certification',
                    ],
                ],
            ],
            'content_schema' => [
                ['name' => 'badge', 'label' => 'Badge Text', 'type' => 'text'],
                ['name' => 'description', 'label' => 'Section Description', 'type' => 'textarea'],
                [
                    'name' => 'items',
                    'label' => 'Awards & Certifications',
                    'type' => 'repeater',
                    'fields' => [
                        ['name' => 'image', 'label' => 'Award/Badge Image', 'type' => 'image'],
                        ['name' => 'title', 'label' => 'Award Title', 'type' => 'text'],
                        ['name' => 'organization', 'label' => 'Awarding Organization', 'type' => 'text'],
                        ['name' => 'year', 'label' => 'Year', 'type' => 'text'],
                        ['name' => 'description', 'label' => 'Description', 'type' => 'text'],
                    ]
                ],
            ],
        ],

        // ============================================================
        // TIMELINE / HISTORY SECTION
        // ============================================================
        [
            'section_key' => 'timeline',
            'name' => 'Timeline / History',
            'description' => 'Display company history or project milestones.',
            'icon' => 'lucide:clock',
            'sort_order' => 21,
            'is_white_background' => 1,
            'default_title' => 'Our Journey',
            'default_subtitle' => 'Milestones that shaped who we are today',
            'default_content' => [
                'badge' => 'Our History',
                'items' => [
                    [
                        'year' => '2010',
                        'title' => 'The Beginning',
                        'description' => 'Started as a small family business with just 2 washing machines and a dream.',
                        'icon' => 'lucide:flag',
                    ],
                    [
                        'year' => '2013',
                        'title' => 'First Expansion',
                        'description' => 'Opened our second location and introduced pickup & delivery service.',
                        'icon' => 'lucide:store',
                    ],
                    [
                        'year' => '2016',
                        'title' => 'Going Green',
                        'description' => 'Transitioned to 100% eco-friendly cleaning products and practices.',
                        'icon' => 'lucide:leaf',
                    ],
                    [
                        'year' => '2019',
                        'title' => 'Digital Transformation',
                        'description' => 'Launched our mobile app and online ordering system.',
                        'icon' => 'lucide:smartphone',
                    ],
                    [
                        'year' => '2022',
                        'title' => 'Industry Recognition',
                        'description' => 'Received Best Laundry Service award and expanded to 5 locations.',
                        'icon' => 'lucide:trophy',
                    ],
                    [
                        'year' => '2024',
                        'title' => 'Today & Beyond',
                        'description' => 'Serving over 15,000 customers with plans for regional expansion.',
                        'icon' => 'lucide:rocket',
                    ],
                ],
            ],
            'content_schema' => [
                ['name' => 'badge', 'label' => 'Badge Text', 'type' => 'text'],
                [
                    'name' => 'items',
                    'label' => 'Timeline Events',
                    'type' => 'repeater',
                    'fields' => [
                        ['name' => 'year', 'label' => 'Year', 'type' => 'text'],
                        ['name' => 'title', 'label' => 'Milestone Title', 'type' => 'text'],
                        ['name' => 'description', 'label' => 'Description', 'type' => 'textarea'],
                        ['name' => 'icon', 'label' => 'Icon', 'type' => 'icon'],
                    ]
                ],
            ],
        ],

        // ============================================================
        // COMPARISON TABLE SECTION
        // ============================================================
        [
            'section_key' => 'comparison',
            'name' => 'Comparison Table',
            'description' => 'Compare your service with competitors or plans.',
            'icon' => 'lucide:table',
            'sort_order' => 22,
            'default_title' => 'Why Choose Us Over Others',
            'default_subtitle' => 'See how we compare to traditional laundry services',
            'default_content' => [
                'badge' => 'Comparison',
                'our_brand' => 'Our Service',
                'competitor' => 'Traditional Services',
                'features' => [
                    ['feature' => 'Free Pickup & Delivery', 'us' => true, 'them' => false],
                    ['feature' => 'Online Scheduling', 'us' => true, 'them' => false],
                    ['feature' => 'Real-time Tracking', 'us' => true, 'them' => false],
                    ['feature' => 'Eco-Friendly Products', 'us' => true, 'them' => false],
                    ['feature' => '24/7 Customer Support', 'us' => true, 'them' => false],
                    ['feature' => 'Satisfaction Guarantee', 'us' => true, 'them' => true],
                    ['feature' => 'Same-Day Service', 'us' => true, 'them' => false],
                    ['feature' => 'Transparent Pricing', 'us' => true, 'them' => false],
                ],
            ],
            'content_schema' => [
                ['name' => 'badge', 'label' => 'Badge Text', 'type' => 'text'],
                ['name' => 'our_brand', 'label' => 'Your Brand Name', 'type' => 'text'],
                ['name' => 'competitor', 'label' => 'Competitor Label', 'type' => 'text'],
                [
                    'name' => 'features',
                    'label' => 'Comparison Features',
                    'type' => 'repeater',
                    'fields' => [
                        ['name' => 'feature', 'label' => 'Feature Name', 'type' => 'text'],
                        ['name' => 'us', 'label' => 'We Have It', 'type' => 'switch'],
                        ['name' => 'them', 'label' => 'They Have It', 'type' => 'switch'],
                    ]
                ],
            ],
        ],

        // ============================================================
        // SPECIAL OFFER / PROMO BANNER SECTION
        // ============================================================
        [
            'section_key' => 'promo_banner',
            'name' => 'Promo Banner',
            'description' => 'Highlight special offers, discounts, or announcements.',
            'icon' => 'lucide:megaphone',
            'sort_order' => 24,
            'default_title' => 'Special Offer',
            'default_subtitle' => 'Limited time only!',
            'default_content' => [
                'headline' => '50% OFF Your First Order!',
                'description' => 'New customers get 50% off their first laundry order. Use code WELCOME50 at checkout.',
                'promo_code' => 'WELCOME50',
                'show_promo_code' => true,
                'promo_code_label' => 'Use promo code:',
                'copied_message' => 'Copied to clipboard!',
                'cta_text' => 'Claim Offer',
                'cta_url' => '#contact',
                'expiry_date' => '', // Format: 'YYYY-MM-DD HH:MM:SS' or '2026-12-31 23:59:59'
                'show_countdown' => false,
                'countdown_label' => 'Offer ends in:',
                'countdown_days_label' => 'Days',
                'countdown_hours_label' => 'Hrs',
                'countdown_minutes_label' => 'Mins',
                'countdown_seconds_label' => 'Secs',
                'discount_value' => '50%',
                'discount_label' => 'OFF',
                'icon' => 'lucide:gift',
                'terms' => 'Valid for new customers only. Cannot be combined with other offers.',
            ],
            'content_schema' => [
                ['name' => 'headline', 'label' => 'Headline', 'type' => 'text'],
                ['name' => 'description', 'label' => 'Description', 'type' => 'textarea'],
                ['name' => 'promo_code', 'label' => 'Promo Code', 'type' => 'text'],
                ['name' => 'show_promo_code', 'label' => 'Show Promo Code Box', 'type' => 'switch'],
                ['name' => 'promo_code_label', 'label' => 'Promo Code Label', 'type' => 'text'],
                ['name' => 'copied_message', 'label' => 'Copied Message', 'type' => 'text'],
                ['name' => 'cta_text', 'label' => 'Button Text', 'type' => 'text'],
                ['name' => 'cta_url', 'label' => 'Button URL', 'type' => 'text'],
                ['name' => 'expiry_date', 'label' => 'Expiry Date (YYYY-MM-DD HH:MM:SS)', 'type' => 'text'],
                ['name' => 'show_countdown', 'label' => 'Show Countdown Timer', 'type' => 'switch'],
                ['name' => 'countdown_label', 'label' => 'Countdown Label', 'type' => 'text'],
                ['name' => 'countdown_days_label', 'label' => 'Days Label', 'type' => 'text'],
                ['name' => 'countdown_hours_label', 'label' => 'Hours Label', 'type' => 'text'],
                ['name' => 'countdown_minutes_label', 'label' => 'Minutes Label', 'type' => 'text'],
                ['name' => 'countdown_seconds_label', 'label' => 'Seconds Label', 'type' => 'text'],
                ['name' => 'discount_value', 'label' => 'Discount Value (e.g., 50%)', 'type' => 'text'],
                ['name' => 'discount_label', 'label' => 'Discount Label (e.g., OFF)', 'type' => 'text'],
                ['name' => 'icon', 'label' => 'Icon', 'type' => 'icon'],
                ['name' => 'terms', 'label' => 'Terms & Conditions', 'type' => 'textarea'],
            ],
        ],

        // ============================================================
        // FOOTER SECTION
        // ============================================================
        [
            'section_key' => 'footer',
            'name' => 'Footer Section',
            'description' => 'Website footer with company info, links, and social media.',
            'icon' => 'lucide:align-justify',
            'sort_order' => 13,
            'default_title' => null,
            'default_subtitle' => null,
            'default_content' => [
                'description' => 'Professional laundry and dry cleaning services with free pickup & delivery.',
                'link_groups' => [
                    [
                        'title' => 'Company',
                        'links' => [
                            ['title' => 'About Us', 'url' => '#about'],
                            ['title' => 'Our Team', 'url' => '#team'],
                            ['title' => 'Careers', 'url' => '#careers'],
                            ['title' => 'Contact', 'url' => '#contact'],
                        ],
                    ],
                    [
                        'title' => 'Support',
                        'links' => [
                            ['title' => 'FAQ', 'url' => '#faq'],
                            ['title' => 'Help Center', 'url' => '#help'],
                            ['title' => 'Service Areas', 'url' => '#service-areas'],
                        ],
                    ],
                ],
                'contact_title' => 'Contact Us',
                'copyright' => '© %year% %business%. All rights reserved.',
            ],
            'content_schema' => [
                ['name' => 'description', 'label' => 'Footer Description', 'type' => 'textarea'],
                [
                    'name' => 'link_groups',
                    'label' => 'Footer Link Groups',
                    'type' => 'repeater',
                    'fields' => [
                        ['name' => 'title', 'label' => 'Group Title', 'type' => 'text'],
                        [
                            'name' => 'links',
                            'label' => 'Links',
                            'type' => 'nested_repeater',
                            'fields' => [
                                ['name' => 'title', 'label' => 'Link Title', 'type' => 'text'],
                                ['name' => 'url', 'label' => 'Link URL', 'type' => 'text'],
                            ],
                        ],
                    ],
                ],
                ['name' => 'contact_title', 'label' => 'Contact Title', 'type' => 'text'],
                ['name' => 'copyright', 'label' => 'Copyright Text', 'type' => 'text'],
            ],
        ],
    ];

    /**
     * Extract translations from content_schema fields
     * Creates key-value pairs from field names and their labels
     *
     * @param array $contentSchema
     * @param string $sectionKey
     * @return array
     */
    public static function extractTranslations(array $contentSchema, string $sectionKey): array
    {
        $translations = [];

        foreach ($contentSchema as $field) {
            if (isset($field['name']) && isset($field['label'])) {
                // Create translation key: section_key.field_name
                $key = $sectionKey . '_' . $field['name'];
                $translations[$key] = $field['label'];
            }

            // Handle repeater fields with nested fields
            if (isset($field['type']) && $field['type'] === 'repeater' && isset($field['fields'])) {
                foreach ($field['fields'] as $nestedField) {
                    if (isset($nestedField['name']) && isset($nestedField['label'])) {
                        $key = $sectionKey . '_' . $field['name'] . '_' . $nestedField['name'];
                        $translations[$key] = $nestedField['label'];
                    }

                    // Handle nested_repeater (e.g., social_links in team section)
                    if (isset($nestedField['type']) && $nestedField['type'] === 'nested_repeater' && isset($nestedField['fields'])) {
                        foreach ($nestedField['fields'] as $deepNestedField) {
                            if (isset($deepNestedField['name']) && isset($deepNestedField['label'])) {
                                $key = $sectionKey . '_' . $field['name'] . '_' . $nestedField['name'] . '_' . $deepNestedField['name'];
                                $translations[$key] = $deepNestedField['label'];
                            }
                        }
                    }
                }
            }

            // Handle select options
            if (isset($field['type']) && $field['type'] === 'select' && isset($field['options'])) {
                foreach ($field['options'] as $option) {
                    if (isset($option['value']) && isset($option['label'])) {
                        $key = $sectionKey . '_' . $field['name'] . '_option_' . $option['value'];
                        $translations[$key] = $option['label'];
                    }
                }
            }
        }

        return $translations;
    }

    public static function seedThemeSections()
    {
        foreach (self::$sections as $section) {
            // Check if section_key already exists
            $exists = DB::table('theme_sections')
                ->where('section_key', $section['section_key'])
                ->exists();

            if ($exists) {
                continue;
            }

            // Extract translations from content_schema
            $translations = self::extractTranslations(
                $section['content_schema'] ?? [],
                $section['section_key']
            );

            DB::table('theme_sections')->insert([
                'section_key' => $section['section_key'],
                'name' => $section['name'],
                'description' => $section['description'] ?? null,
                'icon' => $section['icon'] ?? null,
                'preview_image' => $section['preview_image'] ?? null,
                'default_title' => $section['default_title'] ?? null,
                'default_subtitle' => $section['default_subtitle'] ?? null,
                'default_content' => json_encode($section['default_content'] ?? []),
                'content_schema' => json_encode($section['content_schema'] ?? []),
                'translations' => json_encode($translations),
                'sort_order' => $section['sort_order'] ?? 0,
                'is_white_background' => $section['is_white_background'] ?? false,
                'is_active' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}
