<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Services\ModuleMenuService;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

/**
 * ModuleMenuController
 *
 * API endpoint to return module menu structure with assets for dynamic loading.
 */
class ModuleMenuController extends Controller
{
    protected ModuleMenuService $menuService;

    public function __construct(ModuleMenuService $menuService)
    {
        $this->menuService = $menuService;
    }

    /**
     * Get module menu items for the authenticated user.
     *
     * @param Request $request
     * @return JsonResponse
     */
    public function index(Request $request): JsonResponse
    {
        $user = $request->user();
        $menus = $this->menuService->getMenuItems($user);

        return response()->json([
            'success' => true,
            'data' => $menus,
        ]);
    }

    /**
     * Clear module menu cache.
     *
     * @return JsonResponse
     */
    public function clearCache(): JsonResponse
    {
        $this->menuService->clearCache();

        return response()->json([
            'success' => true,
            'message' => 'Module menu cache cleared successfully.',
        ]);
    }
}
