<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\ApiBaseController;
use App\Http\Requests\Api\EmailTemplate\IndexRequest;
use App\Http\Requests\Api\EmailTemplate\UpdateRequest;
use App\Models\Settings;

class EmailTemplateController extends ApiBaseController
{
    /**
     * The model associated with the controller.
     *
     * @var string
     */
    protected $model = Settings::class;

    /**
     * The request class for index operations.
     *
     * @var string
     */
    protected $indexRequest = IndexRequest::class;

    /**
     * The request class for update operations.
     *
     * @var string
     */
    protected $updateRequest = UpdateRequest::class;

    /**
     * Modify the index query to filter by setting type and company
     *
     * @param \Illuminate\Database\Eloquent\Builder $query
     * @return \Illuminate\Database\Eloquent\Builder
     */
    protected function modifyIndex($query)
    {
        $company = company();
        $query = $query->where('setting_type', 'email_templates')
            ->where('company_id', $company->id);

        // $type = request('type');
        // if ($type === 'company') {
        //     $query = $query->where('name_key', 'like', 'company_%');
        // } elseif ($type === 'employee') {
        //     $query = $query->where('name_key', 'like', 'employee_%');
        // }

        return  $query;
    }

    /**
     * Hook: Before updating a settings record
     * Update the name from credentials title
     *
     * @param Settings $settings
     * @return Settings
     */
    public function updating(Settings $settings)
    {
        $request = request();
        $settings->name = $request->has('credentials') && $request->credentials['title'] ? $request->credentials['title'] : $settings->name;

        return  $settings;
    }
}
