<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\ApiBaseController;
use App\Http\Requests\Api\ThemeSection\IndexRequest;
use App\Models\ThemeSection;

class ThemeSectionController extends ApiBaseController
{
    protected $model = ThemeSection::class;

    protected $indexRequest = IndexRequest::class;

    /**
     * Modify index query
     */
    protected function modifyIndex($query)
    {
        // Only return active sections
        $query->where('is_active', true);

        // Order by sort_order
        $query->orderBy('sort_order');

        return $query;
    }
}
