<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Bus\DispatchesJobs;
use App\Classes\Common;

class ApiBaseController extends ApiMainController
{
    use AuthorizesRequests, DispatchesJobs;

    public $company = [];

    public function __construct()
    {
        parent::__construct();

        // Storage and mail config settings are set by their respective Service Providers:
        // - StorageSettingsProvider handles storage configuration
        // - SmtpSettingsProvider handles mail configuration
    }

    public function getIdFromHash($hash)
    {
        return Common::getIdFromHash($hash);
    }

    public function getHashFromId($id)
    {
        return Common::getHashFromId($id);
    }

    public function getIdArrayFromHash($values)
    {
        $convertedArray = [];

        foreach ($values as $value) {
            $convertedArray[] = $this->getIdFromHash($value);
        }

        return $convertedArray;
    }

    public function getHashArrayFromId($values)
    {
        $convertedArray = [];

        foreach ($values as $value) {
            $convertedArray[] = $this->getHashFromId($value);
        }

        return $convertedArray;
    }

    public function errorMessageResponse($message)
    {
        return response()->json([
            'code' => 403,
            'message' => $message
        ], 403);
    }
}
