<?php

namespace App\Http\Middleware;

use Closure;
use Examyou\RestAPI\Exceptions\UnauthorizedException;
use Illuminate\Support\Str;
use Nwidart\Modules\Facades\Module;

class CheckPermission
{

    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if (auth('api')->check()) {
            $user = auth('api')->user();
            $resourceRequests = ['index', 'store', 'update', 'show', 'destroy'];
            $urlArray = explode('.', $request->route()->action['as']);

            $enabledModuleNames = collect(Module::allEnabled())->keys()->toArray();

            // Check if this is a module route (5 parts) or regular route (4 parts)
            // Module route: api.laundry.services.index.v1 (5 parts)
            // Regular route: api.staff-members.index.v1 (4 parts)
            // Convert enabled module names to lowercase for comparison
            $enabledModuleNamesLower = array_map(fn($name) => Str::of($name)->lower()->toString(), $enabledModuleNames);

            $moduleName = '';
            if (count($urlArray) == 5) {
                // Convert kebab-case to lowercase without hyphens (e.g., "laundry" -> "laundry")
                $potentialModuleName = Str::of($urlArray[1])->replace('-', '')->lower()->toString();
                if (in_array($potentialModuleName, $enabledModuleNamesLower)) {
                    // This is a module route
                    $moduleName = $potentialModuleName . '_';
                    $routePathString = Str::of($urlArray[2])->replace('-', '_')->toString();
                    $resourceRequestString = $urlArray[3];
                } else {
                    // Not a valid module, treat as regular route
                    $routePathString = Str::of($urlArray[1])->replace('-', '_')->toString();
                    $resourceRequestString = $urlArray[2];
                }
            } else {
                // Regular route (4 parts)
                $routePathString = Str::of($urlArray[1])->replace('-', '_')->toString();
                $resourceRequestString = $urlArray[2];
            }

            // Those route for which we don't want to check permission
            // We will check permission for those on controller level
            $skipResourcePath = ['get_assigned_survey'];

            // Routes that always require permission check, regardless of fields parameter
            $alwaysCheckPermission = ['website_builder'];

            if (in_array($resourceRequestString, $resourceRequests) && in_array($routePathString, $skipResourcePath) === false) {

                // Lang resource will have translations permission
                if ($routePathString == 'langs') {
                    $routePathString = "translations";
                } else if ($routePathString == 'get_all_transitions') {
                    $routePathString = "accounts";
                }

                $permission = "";
                $requestFields = $request->fields;

                if (($resourceRequestString == 'index' || $resourceRequestString == 'show')) {
                    // Always check permission for certain routes, regardless of fields parameter
                    if (in_array($routePathString, $alwaysCheckPermission)) {
                        $permission = $moduleName . '' . $routePathString . '_view';
                    } else if ($requestFields == null) {
                        // If no fields params is passed in index request
                        config(['api.defaultLimit' => 10000]);
                    } else {
                        $permission = $moduleName . '' . $routePathString . '_view';
                    }
                }

                if ($resourceRequestString == 'store') {
                    $permission = $moduleName . '' . $routePathString . '_create';
                } else if ($resourceRequestString == 'update') {
                    $permission = $moduleName . '' . $routePathString . '_edit';
                } else if ($resourceRequestString == 'destroy') {
                    $permission = $moduleName . '' . $routePathString . '_delete';
                }

                if ($permission != "" && !$user->ability('admin', $permission)) {
                    throw new UnauthorizedException("Don't have valid permission");
                }
            }
        }

        return $next($request);
    }
}
