<?php

namespace App\Http\Requests\Api\Auth;

use Illuminate\Foundation\Http\FormRequest;

class ProfileRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {

        $rules = [
            'name' => 'required',
            'email' => 'required|email',
            'phone' => 'integer',
            'profile_image' => ($this->hasFile('profile_image') && $this->file('profile_image')->isValid())
                ? 'required|image|mimes:jpeg,jpg,png,gif,webp'
                : 'nullable'
        ];

        if ($this->has('password') && $this->password != '') {
            $rules['password'] = 'min:8';
        }

        return $rules;
    }
}
