<?php

namespace App\Http\Requests\Api\Auth;

use App\Helpers\Files;
use Illuminate\Foundation\Http\FormRequest;

class UploadFileRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $folder = $this->folder;

        $rules = [
            'folder' => 'required'
        ];

        if ($this->has('image')) {
            $rules['image'] = 'required|image|max:20000';
        }

        if ($this->has('file')) {
            // Default to image validation
            $rules['file'] = 'required|image|max:20000';

            // Folder-specific validation
            if ($folder == 'expenses') {
                $rules['file'] = 'required|mimes:csv,txt,xlx,xls,pdf,docx,txt,jpg,jpeg,svg,png|max:20000';
            } else if ($folder == 'policyDocuments') {
                $rules['file'] = 'required|mimes:pdf,docx,txt|max:20000';
            } else if ($folder == 'fonts') {
                $rules['file'] = 'required|mimes:ttf,otf,woff,woff2,eot|max:20000';
            } else if ($folder == 'test-uploads') {
                // For storage test uploads - allow common safe file types only
                $rules['file'] = 'required|mimes:jpg,jpeg,png,gif,svg,webp,bmp,pdf,txt,docx,xlsx,zip|max:10240';
            } else if ($folder == 'user' || $folder == 'company' || $folder == 'langs') {
                $rules['file'] = 'required|mimes:jpg,jpeg,png,gif,svg,webp,bmp|max:20000';
            }
        }

        return $rules;
    }

    /**
     * Configure the validator instance.
     *
     * @param \Illuminate\Validation\Validator $validator
     * @return void
     */
    public function withValidator($validator)
    {
        $validator->after(function ($validator) {
            $uploadedFile = $this->hasFile('image') ? $this->file('image') : $this->file('file');

            if ($uploadedFile) {
                Files::validateUploadedFile($uploadedFile);
            }
        });
    }
}
