<?php

namespace App\Http\Requests\Api\IconSet;

use Illuminate\Foundation\Http\FormRequest;

class StoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name' => 'required|string|max:100',
            'prefix' => 'required|string|max:50|unique:icon_sets,prefix',
            'sort_order' => 'nullable|integer|min:0',
            'is_active' => 'nullable|boolean',
            'icons' => 'nullable|array',
            'icons.*' => 'string|max:100',
        ];
    }
}
