<?php

namespace App\Http\Requests\Api\IconSet;

use Vinkla\Hashids\Facades\Hashids;
use Illuminate\Foundation\Http\FormRequest;

class UpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $convertedId = Hashids::decode($this->route('icon_set'));
        $id = $convertedId[0] ?? null;

        return [
            'name' => 'required|string|max:100',
            'prefix' => 'required|string|max:50|unique:icon_sets,prefix,' . $id,
            'sort_order' => 'nullable|integer|min:0',
            'is_active' => 'nullable|boolean',
            'icons' => 'nullable|array',
            'icons.*' => 'string|max:100',
        ];
    }
}
