<?php

namespace App\Http\Requests\Api\StaffMember;

use Illuminate\Validation\Rule;
use App\Http\Requests\Api\BaseRequest;

class BulkStoreRequest extends BaseRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'staff_members' => 'required|array|min:1',
            'staff_members.*.name' => 'required|string|max:255',
            'staff_members.*.email' => [
                'required',
                'email',
                Rule::unique('users', 'email')->where(function ($query) {
                    return $query->where('user_type', 'staff_members')
                        ->orWhere('user_type', 'super_admins');
                }),
                'distinct',
            ],
            'staff_members.*.password' => 'required_if:staff_members.*.allow_login,1|nullable|min:8',
            'staff_members.*.role_id' => 'required_if:staff_members.*.allow_login,1|nullable',
            'staff_members.*.allow_login' => 'nullable|boolean',
            'staff_members.*.status' => 'nullable|in:active,inactive',
        ];
    }

    /**
     * Get custom messages for validator errors.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'staff_members.*.name.required' => 'Name is required for each staff member.',
            'staff_members.*.email.required' => 'Email is required for each staff member.',
            'staff_members.*.email.email' => 'Please enter a valid email address.',
            'staff_members.*.email.unique' => 'This email is already registered.',
            'staff_members.*.email.distinct' => 'Duplicate email addresses are not allowed.',
            'staff_members.*.password.required_if' => 'Password is required when login is allowed.',
            'staff_members.*.password.min' => 'Password must be at least 8 characters.',
            'staff_members.*.role_id.required_if' => 'Role is required when login is allowed.',
        ];
    }
}
