<?php

namespace App\Http\Requests\Api\StaffMember;

use Illuminate\Validation\Rule;
use App\Http\Requests\Api\BaseRequest;

class ImportRequest extends BaseRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'staff_members' => 'required|array|min:1',
            'staff_members.*.name' => 'required|string|max:255',
            'staff_members.*.email' => [
                'required',
                'email',
                Rule::unique('users', 'email')->where(function ($query) {
                    return $query->where('user_type', 'staff_members')
                        ->orWhere('user_type', 'super_admins');
                }),
                'distinct',
            ],
            'staff_members.*.phone' => 'nullable|string|max:20',
            'staff_members.*.status' => 'nullable|in:active,inactive',
            'staff_members.*.address' => 'nullable|string|max:500',
        ];
    }

    /**
     * Get custom messages for validator errors.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'staff_members.*.name.required' => 'Name is required for each staff member.',
            'staff_members.*.name.max' => 'Name must not exceed 255 characters.',
            'staff_members.*.email.required' => 'Email is required for each staff member.',
            'staff_members.*.email.email' => 'Please enter a valid email address.',
            'staff_members.*.email.unique' => 'This email is already registered.',
            'staff_members.*.email.distinct' => 'Duplicate email addresses are not allowed.',
            'staff_members.*.phone.max' => 'Phone number must not exceed 20 characters.',
            'staff_members.*.status.in' => 'Status must be either active or inactive.',
            'staff_members.*.address.max' => 'Address must not exceed 500 characters.',
        ];
    }
}
