<?php

namespace App\Http\Requests\Api\StaffMember;

use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;
use Vinkla\Hashids\Facades\Hashids;
use App\Models\Role;
use App\Classes\Common;
use App\Models\User;

class UpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $loggedUser = auth('api')->user();
        $convertedId = Hashids::decode($this->route('staff_member'));
        $id = $convertedId[0];

        $rules = [
            'name' => 'required',
            'phone'  => [
                'nullable',
                'regex:/^\+[1-9]\d{6,14}$/', // Require + sign (E.164 format)
                'phone:AUTO',
            ],
            'email'    => [
                'required',
                'email:rfc,dns',
                'indisposable',
                'email',
                Rule::unique('users', 'email')->where(function ($query) {
                    return $query->where('user_type', 'staff_members')
                        ->orWhere('user_type', 'super_admins');
                })->ignore($id)
            ],
            'status' => 'required',
        ];

        // allow_login, role_id, and password are only validated when user has assign_role permission
        if ($loggedUser && $loggedUser->ability('admin', 'assign_role')) {
            if ($this->password != '') {
                $rules['password'] = 'required|min:8';
            }

            if ($this->allow_login == 1) {
                $rules['role_id'] = 'required';

                $user = User::find($id);
                if ($user->password == "") {
                    $rules['password'] = 'required|min:8';
                }
            }
        }

        return $rules;
    }

    public function messages()
    {
        return [
            'phone.phone'    => 'The :attribute field must be a valid number.',
            'phone.regex' => 'The phone number must include the country code with + sign.',
        ];
    }
}
