<?php

namespace App\Http\Requests\Api\Website;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Vinkla\Hashids\Facades\Hashids;

class StoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */

    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $companyId = company()->id;

        return [
            'name' => 'required|string',
            'slug' => [
                'required',
                'string',
                'regex:/^[a-z0-9]+(?:-[a-z0-9]+)*$/',
                Rule::unique('websites', 'slug')->where(function ($query) use ($companyId) {
                    return $query->where('company_id', $companyId);
                }),
            ],
            'website_category_id' => 'nullable',
            'theme_name' => 'nullable|string',
            'theme_primary_color' => 'nullable|string',
            'theme_secondary_color' => 'nullable|string',
            'theme_mode' => 'nullable|in:light,dark',
            'front_default_website_language_id' => 'nullable',
            'custom_css' => 'nullable|string|max:65535',
            'custom_js' => 'nullable|string|max:65535',
        ];
    }

    public function messages()
    {
        return [
            'slug.unique' => 'This slug is already taken. Please use a different name.',
            'slug.regex' => 'Slug can only contain lowercase letters, numbers, and hyphens.',
        ];
    }
}
