<?php

namespace App\Http\Requests\Api\WebsiteLegalPage;

use App\Classes\Common;
use App\Models\Lang;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Vinkla\Hashids\Facades\Hashids;

class StoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */

    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $company = company();
        $companyId = $company ? $company->id : null;

        // Decode website_id from request
        $websiteId = null;
        if ($this->has('website_id') && $this->input('website_id')) {
            $websiteId = Common::getIdFromHash($this->input('website_id'));
        }

        // Decode website_language_id from request, default to English
        $langId = null;
        if ($this->has('website_language_id') && $this->input('website_language_id')) {
            $langId = Common::getIdFromHash($this->input('website_language_id'));
        } else {
            $enLang = Lang::where('key', 'en')->first();
            $langId = $enLang ? $enLang->id : null;
        }

        $rules = [
            'title' => 'required|string',
            'slug' => [
                'required',
                'string',
                Rule::unique('website_legal_pages', 'slug')
                    ->where('company_id', $companyId)
                    ->where('website_id', $websiteId)
                    ->where('website_language_id', $langId)
            ],
            'content' => 'required|string',
            'meta_title' => 'required|string',
            'meta_description' => 'required|string',
            'meta_keywords' => 'required|string',
            'status' => 'required|in:active,inactive'
        ];

        return $rules;
    }
}
