<?php

namespace App\Http\Requests\Api\WebsiteLegalPage;

use App\Models\WebsiteLegalPage;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Vinkla\Hashids\Facades\Hashids;

class UpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */

    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $company = company();
        $companyId = $company ? $company->id : null;

        // Get the ID from route parameter
        $websiteLegalPageId = $this->route('website_legal_page');
        $decodedId = Hashids::decode($websiteLegalPageId);
        $id = $decodedId[0] ?? null;

        // Get the website legal page to get website_id and website_language_id
        $websiteLegalPage = WebsiteLegalPage::find($id);
        $websiteId = $websiteLegalPage ? $websiteLegalPage->website_id : null;
        $langId = $websiteLegalPage ? $websiteLegalPage->website_language_id : null;

        return [
            'title' => 'required|string',
            'slug' => [
                'required',
                'string',
                Rule::unique('website_legal_pages', 'slug')
                    ->where('company_id', $companyId)
                    ->where('website_id', $websiteId)
                    ->where('website_language_id', $langId)
                    ->ignore($id)
            ],
            'content' => 'required|string',
            'meta_title' => 'required|string',
            'meta_description' => 'required|string',
            'meta_keywords' => 'required|string',
            'status' => 'required|in:active,inactive'
        ];
    }
}
