<?php

namespace App\Models;

use App\Models\BaseModel;
use App\Models\Currency;
use Illuminate\Database\Eloquent\Builder;
use Laravel\Cashier\Billable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Support\Facades\Schema;

class Company extends BaseModel
{
    use Billable, Notifiable;

    protected $table = 'companies';

    protected $dates = ['licence_expire_on'];

    protected $default = ['xid'];

    protected $guarded = ['id', 'is_global', 'subscription_plan_id', 'licence_expire_on', 'package_type', 'stripe_id', 'trial_ends_at',  'created_at', 'updated_at'];

    protected $hidden = ['id', 'currency_id',  'admin_id', 'lang_id', 'subscription_plan_id', 'updated_at', 'pdf_font_id'];

    protected $images = [
        'login_image' => 'login_background.svg',
        'light_logo' => 'light.png',
        'dark_logo' => 'dark.png',
        'small_light_logo' => 'small_light.png',
        'small_dark_logo' => 'small_dark.png',
    ];

    protected $foreignKeys = ['currency_id', 'admin_id', 'lang_id', 'subscription_plan_id', 'pdf_font_id'];

    protected $casts = [
        'licence_expire_on' => 'datetime',
        'app_debug' => 'integer',
        'auto_detect_timezone' => 'integer',
        'update_app_notification' => 'integer',
        'is_global' => 'integer',
        'verified' => 'integer',
        'pdf_show_company_name' => 'integer',
        'pdf_show_company_email' => 'integer',
        'pdf_show_company_phone' => 'integer',
        'pdf_show_company_address' => 'integer',
        'title_show_in_pdf' => 'integer',
        'pdf_left_space' => 'integer',
        'pdf_right_space' => 'integer',
        'pdf_top_space' => 'integer',
        'pdf_bottom_space' => 'integer',
        'pdf_font_size' => 'integer',
        'pdf_line_height' => 'integer',
        'use_custom_font' => 'integer',
        'capture_location' => 'integer',
    ];

    protected $filterable = ['name'];

    protected static function boot()
    {
        parent::boot();

        // Only add global scope if table exists (to allow migrations to run)
        try {
            if (Schema::hasTable('companies')) {
                static::addGlobalScope('company', function (Builder $builder) {
                    $builder->where('companies.is_global', 0);
                });
            }
        } catch (\Exception $e) {
            // Table doesn't exist yet, skip global scope
        }
    }

    public function currency()
    {
        return $this->belongsTo(Currency::class);
    }

    public function lang()
    {
        return $this->belongsTo(Lang::class);
    }

    public function subscriptionPlan()
    {
        return $this->belongsTo(SubscriptionPlan::class);
    }

    public function admin()
    {
        return $this->belongsTo(StaffMember::class, 'admin_id', 'id');
    }

    public function pdfFont()
    {
        return $this->belongsTo(PdfFonts::class, 'pdf_font_id', 'id');
    }
}
