<?php

namespace App\Models;

class Icon extends BaseModel
{
    protected $table = 'icons';

    protected $default = ['xid', 'name', 'full_name'];

    protected $guarded = ['id', 'created_at', 'updated_at'];

    protected $hidden = [];

    protected $filterable = ['name', 'full_name', 'is_active', 'icon_set_id'];

    protected $images = [];

    protected $files = [];

    protected $foreignKeys = ['icon_set_id'];

    protected $casts = [
        'tags' => 'array',
        'is_active' => 'boolean',
    ];

    /**
     * Get the icon set this icon belongs to
     */
    public function iconSet()
    {
        return $this->belongsTo(IconSet::class, 'icon_set_id');
    }

    /**
     * Scope for active icons
     */
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    /**
     * Search icons by name or tags
     */
    public static function search(string $query, $iconSetId = null)
    {
        $search = static::where('is_active', true)
            ->where(function ($q) use ($query) {
                $q->where('name', 'like', "%{$query}%")
                  ->orWhere('full_name', 'like', "%{$query}%")
                  ->orWhereJsonContains('tags', $query);
            });

        if ($iconSetId) {
            $search->where('icon_set_id', $iconSetId);
        }

        return $search->get();
    }
}
