<?php

namespace App\Models;

class IconSet extends BaseModel
{
    protected $table = 'icon_sets';

    protected $default = ['xid', 'name', 'prefix', 'icons_count'];

    protected $guarded = ['id', 'created_at', 'updated_at'];

    protected $hidden = [];

    protected $appends = ['icons_count'];

    protected $filterable = ['name', 'prefix', 'is_active'];

    protected $images = [];

    protected $files = [];

    protected $foreignKeys = [];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    /**
     * Get icons count attribute
     */
    public function getIconsCountAttribute()
    {
        // If icons_count is already loaded via withCount, use it
        if (array_key_exists('icons_count', $this->attributes)) {
            return $this->attributes['icons_count'];
        }

        // Otherwise, count the icons
        return $this->icons()->count();
    }

    /**
     * Get icons belonging to this set
     */
    public function icons()
    {
        return $this->hasMany(Icon::class, 'icon_set_id');
    }

    /**
     * Get active icons belonging to this set
     */
    public function activeIcons()
    {
        return $this->hasMany(Icon::class, 'icon_set_id')->where('is_active', true);
    }

    /**
     * Get all active icon sets
     */
    public static function getActiveSets()
    {
        return static::where('is_active', true)
            ->orderBy('sort_order')
            ->get();
    }

    /**
     * Get icon set by prefix
     */
    public static function getByPrefix(string $prefix)
    {
        return static::where('prefix', $prefix)->first();
    }
}
