<?php

namespace App\Models;

class Lang extends BaseModel
{
	protected  $table = 'langs';

	protected $default = ['xid', 'name', 'key'];

	protected $guarded = ['id', 'created_at', 'updated_at'];

	protected $hidden = ['id'];

	protected $appends = ['xid'];

	protected $filterable = ['name'];

	protected $casts = [
		'enabled' => 'integer',
		'is_rtl' => 'boolean',
	];

	public function translations()
	{
		return $this->hasMany(Translation::class);
	}
}
