<?php

namespace App\Models;

use App\Models\BaseModel;
use App\Scopes\CompanyScope;

class PdfFonts extends BaseModel
{
    protected $table = 'pdf_fonts';

    protected $default = ['xid', 'name', 'file', 'user_kashida', 'use_otl'];

    protected $guarded = ['id', 'created_at', 'updated_at'];

    protected $hidden = [];

    protected $appends = ['short_name'];

    protected $filterable = ['name'];

    protected $files = ['file'];

    protected $foreignKeys = ['company_id'];

    protected static function boot()
    {
        parent::boot();

        static::addGlobalScope(new CompanyScope);
    }

    public function getShortNameAttribute()
    {
        // Convert to lowercase, replace spaces with underscores, remove special chars
        return strtolower(preg_replace('/[^a-zA-Z0-9_]/', '', str_replace(' ', '_', $this->name)));
    }
}
