<?php

namespace App\Models;

class ThemeSection extends BaseModel
{
    protected $table = 'theme_sections';

    protected $default = ['id', 'xid', 'section_key', 'module_name', 'name', 'description', 'icon', 'preview_image', 'preview_image_url', 'default_title', 'default_subtitle', 'default_content', 'content_schema', 'sort_order'];

    protected $guarded = ['id', 'created_at', 'updated_at'];

    protected $hidden = [];

    protected $filterable = ['section_key', 'name', 'is_active'];

    protected $images = ['preview_image'];

    protected $files = [];

    protected $foreignKeys = [];

    public $imageFileFolder = "theme_sections";

    protected $casts = [
        'default_content' => 'array',
        'content_schema' => 'array',
        'is_active' => 'boolean',
        'is_white_background' => 'boolean',
    ];

    /**
     * Get all active sections
     */
    public static function getActiveSections()
    {
        $query = static::where('is_active', true)
            ->orderBy('sort_order');

        return $query->get();
    }

    /**
     * Get section by key
     */
    public static function getByKey(string $sectionKey)
    {
        $query = static::where('section_key', $sectionKey);

        return $query->first();
    }
}
