<?php

namespace App\Models;

use App\Traits\EntrustUserTrait;
use Illuminate\Notifications\Notifiable;
use PHPOpenSourceSaver\JWTAuth\Contracts\JWTSubject;
use Illuminate\Auth\Authenticatable;
use Illuminate\Contracts\Auth\Authenticatable as AuthenticatableContract;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Hash as FacadesHash;


class User extends BaseModel implements AuthenticatableContract, JWTSubject
{
    use Notifiable, EntrustUserTrait, Authenticatable, HasFactory;

    protected $table = 'users';

    protected $default = ["xid", "name", "profile_image"];

    protected $guarded = ['id', 'company_id', 'created_at', 'updated_at'];

    protected $hidden = ['password', 'remember_token'];

    protected $images = [
        'profile_image' => 'user.png'
    ];

    protected $filterable = ['name', 'user_type', 'email', 'status', 'phone'];

    protected $foreignKeys = ['company_id', 'role_id'];

    protected $casts = [
        'login_enabled' => 'integer',
        'is_superadmin' => 'integer',
        'allow_login' => 'boolean',
        'last_active_on' => 'datetime',
    ];

    protected static function boot()
    {
        parent::boot();
    }

    public function setPasswordAttribute($value)
    {
        if ($value) {
            $this->attributes['password'] = FacadesHash::make($value);
        }
    }

    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    public function getJWTCustomClaims()
    {
        return [];
    }

    public function company()
    {
        return $this->hasOne(Company::class, 'id', 'company_id');
    }

    public function role()
    {
        return $this->belongsTo(Role::class);
    }
}
