<?php

namespace App\Models;

use App\Models\BaseModel;
use App\Scopes\CompanyScope;

class WebsiteCategory extends BaseModel
{
    protected $table = 'website_categories';

    protected $default = ['xid', 'name', 'image_url'];

    protected $guarded = ['id', 'created_at', 'updated_at'];

    protected $hidden = [];

    protected $appends = ['websites_count'];

    protected $filterable = ['name'];

    protected $images = ['image'];

    protected $files = [];

    protected $foreignKeys = ['company_id'];

    protected $casts = [];

    protected static function boot()
    {
        parent::boot();

        static::addGlobalScope(new CompanyScope);
    }

    /**
     * Get the websites for this category.
     */
    public function websites()
    {
        return $this->hasMany(Website::class, 'website_category_id');
    }

    /**
     * Get the count of websites in this category.
     */
    public function getWebsitesCountAttribute()
    {
        return $this->websites()->count();
    }
}
