<?php

namespace App\Models;

use App\Models\BaseModel;
use App\Scopes\CompanyScope;

class WebsiteLanguage extends BaseModel
{
    protected $table = 'website_languages';

    protected $default = ['id', 'xid', 'name', 'key', 'flag_code', 'is_rtl', 'enabled', 'is_default'];

    protected $guarded = ['id', 'created_at', 'updated_at'];

    protected $hidden = ['id', 'website_id'];

    protected $appends = ['xid', 'x_website_id'];

    protected $filterable = ['name', 'key'];

    protected $images = [];

    protected $files = [];

    protected $foreignKeys = ['company_id', 'website_id'];

    protected $casts = [
        'is_rtl' => 'boolean',
        'enabled' => 'boolean',
        'is_default' => 'boolean',
    ];

    protected static function boot()
    {
        parent::boot();

        static::addGlobalScope(new CompanyScope);
    }

    public function website()
    {
        return $this->belongsTo(Website::class, 'website_id');
    }
}
