<?php

namespace App\Models;

use App\Models\BaseModel;
use App\Scopes\CompanyScope;

class WebsitePage extends BaseModel
{
    protected $table = 'website_pages';

    protected $default = ['id', 'xid', 'page_key', 'sort_order'];

    protected $guarded = ['id', 'created_at', 'updated_at'];

    protected $hidden = ['id', 'company_id', 'website_id'];

    protected $appends = ['xid', 'x_company_id', 'x_website_id'];

    protected $filterable = ['page_key', 'website_id'];

    protected $casts = [
        'sort_order' => 'integer',
    ];

    protected $images = [];

    protected $files = [];

    protected $foreignKeys = ['company_id', 'website_id'];

    protected static function boot()
    {
        parent::boot();

        static::addGlobalScope(new CompanyScope);
    }

    /**
     * Get the website that owns the page.
     */
    public function website()
    {
        return $this->belongsTo(Website::class, 'website_id');
    }

    /**
     * Get all translations for this page.
     */
    public function translations()
    {
        return $this->hasMany(WebsitePageTranslation::class);
    }

    /**
     * Get all website builder sections for this page.
     */
    public function builders()
    {
        return $this->hasMany(WebsiteBuilder::class, 'website_page_id');
    }

    /**
     * Get translation for a specific language.
     */
    public function translation($langId = null)
    {
        return $this->hasOne(WebsitePageTranslation::class)
            ->where('website_language_id', $langId);
    }

    /**
     * Get the name for a specific language (with fallback).
     */
    public function getNameForLang($langId, $fallbackLangId = null)
    {
        $translation = $this->translations()->where('website_language_id', $langId)->first();

        if (!$translation && $fallbackLangId) {
            $translation = $this->translations()->where('website_language_id', $fallbackLangId)->first();
        }

        return $translation ? $translation->name : $this->page_key;
    }
}
