<?php

namespace App\Models;

use App\Models\BaseModel;

class WebsitePageTranslation extends BaseModel
{
    protected $table = 'website_page_translations';

    protected $default = ['xid', 'name', 'show_in_header'];

    protected $guarded = ['id', 'created_at', 'updated_at'];

    protected $hidden = ['id', 'website_page_id', 'website_language_id'];

    protected $appends = ['xid', 'x_website_page_id', 'x_website_language_id'];

    protected $filterable = ['name', 'show_in_header', 'website_page_id', 'website_language_id'];

    protected $images = [];

    protected $files = [];

    protected $foreignKeys = ['website_page_id', 'website_language_id'];

    protected $casts = [
        'show_in_header' => 'boolean',
    ];

    /**
     * Get the website page that owns the translation.
     */
    public function websitePage()
    {
        return $this->belongsTo(WebsitePage::class);
    }

    /**
     * Get the language for this translation.
     */
    public function websiteLanguage()
    {
        return $this->belongsTo(WebsiteLanguage::class, 'website_language_id');
    }
}
