<?php

namespace App\Observers;

use App\Models\PdfFonts;
use Illuminate\Support\Facades\DB;

class PdfFontsObserver
{
    public function saving(PdfFonts $pdfFonts)
    {
        $company = company();

        // Cannot put in creating, because saving is fired before creating. And we need company id for check bellow
        if ($company && !$company->is_global) {
            $pdfFonts->company_id = $company->id;
        }
    }

    public function deleting(PdfFonts $pdfFonts)
    {
        // When a pdf font is deleted, reset use_custom_font for companies using it
        DB::table('companies')
            ->where('pdf_font_id', $pdfFonts->id)
            ->update(['use_custom_font' => false]);
    }
}
