<?php

namespace App\Observers;

use App\Models\WebsiteCategory;

class WebsiteCategoryObserver
{
    public function saving(WebsiteCategory $websiteCategory)
    {
        $company = company();

        // Cannot put in creating, because saving is fired before creating. And we need company id for check bellow
        if ($company && !$company->is_global) {
            $websiteCategory->company_id = $company->id;
        }
    }
}
