<?php

namespace App\Observers;

use App\Models\WebsiteLanguage;

class WebsiteLanguageObserver
{
    public function saving(WebsiteLanguage $websiteLanguage)
    {
        $company = company();

        // Cannot put in creating, because saving is fired before creating. And we need company id for check bellow
        if ($company && !$company->is_global) {
            $websiteLanguage->company_id = $company->id;
        }
    }
}
