<?php

namespace App\Observers;

use App\Models\Website;

class WebsiteObserver
{
    public function saving(Website $website)
    {
        $company = company();

        // Cannot put in creating, because saving is fired before creating. And we need company id for check bellow
        if ($company && !$company->is_global) {
            $website->company_id = $company->id;
        }
    }
}
