<?php

namespace App\Observers;

use App\Models\WebsitePage;

class WebsitePageObserver
{
    public function saving(WebsitePage $websitePage)
    {
        $company = company();

        // Cannot put in creating, because saving is fired before creating. And we need company id for check bellow
        if ($company && !$company->is_global) {
            $websitePage->company_id = $company->id;
        }
    }
}
