<?php

namespace App\Providers;

use Laravel\Cashier\Cashier;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\URL;
use Livewire\Livewire;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        Schema::defaultStringLength(191);

        // Cashier::ignoreMigrations();

        if (env('FORCE_HTTPS', false)) {
            URL::forceScheme('https');
        }

        if (app_type() == 'saas') {
            Cashier::useSubscriptionModel(\App\SuperAdmin\Models\Subscription::class);
        }
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        // Force HTTPS when behind a proxy (ngrok, load balancer, etc.)
        if (request()->header('X-Forwarded-Proto') === 'https' ||
            request()->header('X-Forwarded-Ssl') === 'on' ||
            env('FORCE_HTTPS', false)) {
            URL::forceScheme('https');
            request()->server->set('HTTPS', 'on');
        }

        // Auto-register all themes from resources/views/themes directory
        $this->registerThemes();
    }

    /**
     * Automatically register all theme view and Livewire namespaces
     * from resources/views/themes directory
     *
     * @return void
     */
    protected function registerThemes()
    {
        $themesPath = resource_path('views/themes');

        // Check if themes directory exists
        if (!is_dir($themesPath)) {
            return;
        }

        // Scan all directories in themes folder
        $themeFolders = array_filter(glob($themesPath . '/*'), 'is_dir');

        foreach ($themeFolders as $themePath) {
            $themeName = basename($themePath);

            // Register view namespace
            $this->app['view']->addNamespace($themeName, $themePath);

            // Register Livewire namespace
            Livewire::addNamespace(
                namespace: $themeName,
                viewPath: $themePath
            );
        }
    }
}
