<?php

namespace App\Providers;




use App\Models\Website;
use App\Models\WebsiteCategory;
use App\Models\WebsitePage;
use App\Models\WebsiteSetting;
use App\Models\Company;
use App\Models\Currency;
use App\Models\WebsiteLanguage;
use App\Models\WebsiteLegalPage;
use App\Models\WebsiteBuilder;
use App\Models\PdfFonts;
use App\Models\Role;
use App\Models\Settings;
use App\Models\StaffMember;
use App\Observers\WebsiteCategoryObserver;
use App\Observers\WebsiteObserver;
use App\Observers\WebsitePageObserver;
use App\Observers\WebsiteSettingObserver;
use App\Observers\CurrencyObserver;
use App\Observers\WebsiteLanguageObserver;
use App\Observers\WebsiteLegalPageObserver;
use App\Observers\WebsiteBuilderObserver;
use App\Observers\PdfFontsObserver;
use App\Observers\RoleObserver;
use App\Observers\SettingObserver;
use App\Observers\StaffMemberObserver;
use App\SuperAdmin\Models\SuperAdmin;
use App\SuperAdmin\Observers\CompanyObserver;
use App\SuperAdmin\Observers\SuperAdminObserver;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [];

    /**
     * Register any events for your application.
     *
     * @return void
     */
    public function boot()
    {
        // Don't run observer when
        // we run command using
        if (!app()->runningInConsole()) {
            $appType = app_type();

            StaffMember::observe(StaffMemberObserver::class);
            Settings::observe(SettingObserver::class);
            Currency::observe(CurrencyObserver::class);
            Role::observe(RoleObserver::class);
            PdfFonts::observe(PdfFontsObserver::class);
            Website::observe(WebsiteObserver::class);
            WebsiteCategory::observe(WebsiteCategoryObserver::class);
            WebsitePage::observe(WebsitePageObserver::class);
            WebsiteSetting::observe(WebsiteSettingObserver::class);
            WebsiteLanguage::observe(WebsiteLanguageObserver::class);
            WebsiteLegalPage::observe(WebsiteLegalPageObserver::class);
            WebsiteBuilder::observe(WebsiteBuilderObserver::class);

            if ($appType == 'saas') {
                Company::observe(CompanyObserver::class);
                SuperAdmin::observe(SuperAdminObserver::class);
            }
        }
    }
}
