<?php

use App\Classes\ThemeSections;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('theme_sections', function (Blueprint $table) {
            $table->id();
            $table->string('section_key', 100); // e.g., 'hero', 'features', 'services'
            $table->string('name'); // Display name for the section
            $table->text('description')->nullable(); // Description of what this section does
            $table->string('icon', 50)->nullable(); // Icon for display in UI
            $table->string('preview_image')->nullable(); // Preview thumbnail image
            $table->string('default_title')->nullable(); // Default title for the section
            $table->text('default_subtitle')->nullable(); // Default subtitle for the section
            $table->json('default_content')->nullable(); // Default content values
            $table->json('content_schema')->nullable(); // Schema defining field types for dynamic form generation
            $table->json('translations')->nullable(); // Key-value translations extracted from content_schema labels
            $table->integer('sort_order')->default(0); // Display order in section list
            $table->boolean('is_white_background')->default(false); // Whether to use a white background

            $table->boolean('is_active')->default(true); // Whether this section is available for use
            $table->timestamps();

            // Ensure unique section_key per module
            $table->unique(['section_key']);
        });

        ThemeSections::seedThemeSections();
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('theme_sections');
    }
};
