<?php

use App\Models\Lang;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateLangsTable extends Migration
{

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('langs', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('key');
            $table->string('flag_code', 5)->nullable()->default(null);
            $table->boolean('is_rtl')->default(false);
            $table->boolean('enabled')->default(true);
            $table->timestamps();
        });

        // No observer for Lang
        // So No need to create using DB Class
        $enLang = new Lang();
        $enLang->name = 'English';
        $enLang->key = 'en';
        $enLang->flag_code = 'US';
        $enLang->is_rtl = false;
        $enLang->save();
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('langs');
    }
}
