<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('website_languages', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('company_id')->unsigned()->nullable();
            $table->foreign('company_id')->references('id')->on('companies')->onDelete('cascade')->onUpdate('cascade');
            $table->bigInteger('website_id')->unsigned()->nullable();
            $table->foreign('website_id')->references('id')->on('websites')->onDelete('cascade')->onUpdate('cascade');
            $table->string('name');
            $table->string('key');
            $table->string('flag_code', 5)->nullable()->default(null);
            $table->boolean('is_rtl')->default(false);
            $table->boolean('enabled')->default(true);
            $table->boolean('is_default')->default(false);
            $table->timestamps();
        });

        // Create default English language for each website
        $websites = DB::table('websites')->get();
        foreach ($websites as $website) {
            DB::table('website_languages')->insert([
                'company_id' => $website->company_id,
                'website_id' => $website->id,
                'name' => 'English',
                'key' => 'en',
                'flag_code' => 'US',
                'is_rtl' => false,
                'enabled' => true,
                'is_default' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('website_languages');
    }
};
