<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Base table for website pages (language independent)
        Schema::create('website_pages', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('company_id')->unsigned()->nullable()->default(null);
            $table->foreign('company_id')->references('id')->on('companies')->onDelete('cascade')->onUpdate('cascade');
            $table->bigInteger('website_id')->unsigned()->nullable()->default(null);
            $table->foreign('website_id')->references('id')->on('websites')->onDelete('cascade')->onUpdate('cascade');
            $table->string('page_key');
            $table->integer('sort_order')->default(0);
            $table->timestamps();

            // Unique constraint: page_key must be unique per website_id
            $table->unique(['website_id', 'page_key']);
        });

        // Translations table for language-specific content
        Schema::create('website_page_translations', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('website_page_id')->unsigned();
            $table->foreign('website_page_id')->references('id')->on('website_pages')->onDelete('cascade')->onUpdate('cascade');
            $table->bigInteger('website_language_id')->unsigned();
            $table->foreign('website_language_id')->references('id')->on('website_languages')->onDelete('cascade')->onUpdate('cascade');
            $table->string('name');
            $table->boolean('show_in_header')->default(false);
            $table->timestamps();

            // Unique constraint: one translation per language per page
            $table->unique(['website_page_id', 'website_language_id'], 'wp_trans_page_lang_unique');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('website_page_translations');
        Schema::dropIfExists('website_pages');
    }
};
