<?php

use App\Classes\IconSetsData;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Icon Sets table (e.g., Heroicons, Material Design, etc.)
        Schema::create('icon_sets', function (Blueprint $table) {
            $table->id();
            $table->string('name');           // Display name (e.g., "Heroicons")
            $table->string('prefix')->unique(); // Iconify prefix (e.g., "heroicons")
            $table->integer('sort_order')->default(0);
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });

        // Icons table (individual icons within a set)
        Schema::create('icons', function (Blueprint $table) {
            $table->id();
            $table->foreignId('icon_set_id')->constrained('icon_sets')->onDelete('cascade');
            $table->string('name');           // Icon name (e.g., "home", "user")
            $table->string('full_name');      // Full Iconify name (e.g., "heroicons:home")
            $table->json('tags')->nullable(); // Search tags for better filtering
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });

        // Seed default icon sets
        IconSetsData::seedIconSets();
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('icons');
        Schema::dropIfExists('icon_sets');
    }
};
