<?php

namespace Database\Seeders;

use App\Classes\ThemeSections;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class ThemeSectionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * Seeds all available theme sections with content_schema for dynamic form generation
     *
     * Field types supported:
     * - text: Single line text input
     * - textarea: Multi-line text input
     * - number: Numeric input
     * - select: Dropdown select with options
     * - switch: Boolean toggle switch
     * - icon: Icon picker (Iconify icons)
     * - image: Image upload field
     * - repeater: Array of items with nested fields
     */
    public function run(): void
    {
        // Delete existing theme sections
        DB::table('theme_sections')->delete();

        ThemeSections::seedThemeSections();
    }
}
