<?php

namespace Database\Seeders;

use App\Models\WebsiteCategory;
use App\Models\Company;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class WebsiteCategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Model::unguard();

        DB::table('website_categories')->delete();

        DB::statement('ALTER TABLE website_categories AUTO_INCREMENT = 1');

        // Business categories to seed
        $categories = [
            'Laundry & Dry Cleaning',
            'Restaurant & Food',
            'Salon & Spa',
            'Healthcare & Medical',
            'Fitness & Gym',
            'Real Estate',
            'E-Commerce',
            'Education & Training',
            'Travel & Tourism',
            'Automotive',
            'Photography & Media',
            'Event Management',
            'Consulting & Professional Services',
            'Technology & IT',
            'Retail & Shopping',
        ];

        // Create categories for each company
        $companies = Company::all();

        foreach ($companies as $company) {
            foreach ($categories as $categoryName) {
                WebsiteCategory::create([
                    'company_id' => $company->id,
                    'name' => $categoryName,
                ]);
            }
        }
    }
}
