<?php

namespace Database\Seeders;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class WebsiteLanguageTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */

    public function run()
    {
        Model::unguard();

        DB::table('website_languages')->delete();

        DB::statement('ALTER TABLE website_languages AUTO_INCREMENT = 1');

        // Get all websites
        $websites = DB::table('websites')->get();

        // Seed default languages for each website
        foreach ($websites as $website) {
            // English (default)
            DB::table('website_languages')->insert([
                'company_id' => $website->company_id,
                'website_id' => $website->id,
                'name' => 'English',
                'key' => 'en',
                'flag_code' => 'US',
                'is_rtl' => false,
                'enabled' => true,
                'is_default' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            // Arabic (RTL)
            DB::table('website_languages')->insert([
                'company_id' => $website->company_id,
                'website_id' => $website->id,
                'name' => 'العربية',
                'key' => 'ar',
                'flag_code' => 'SA',
                'is_rtl' => true,
                'enabled' => true,
                'is_default' => false,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}
