<?php

namespace Database\Seeders;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class WebsitePageSeeder extends Seeder
{
    /**
     * Page configurations per category
     * Each category has specific pages relevant to that business type
     */
    protected array $categoryPages = [
        'Laundry & Dry Cleaning' => [
            ['page_key' => 'home', 'name' => ['en' => 'Home', 'ar' => 'الرئيسية'], 'show_in_header' => true, 'sort_order' => 1],
            ['page_key' => 'services', 'name' => ['en' => 'Services', 'ar' => 'الخدمات'], 'show_in_header' => true, 'sort_order' => 2],
            ['page_key' => 'pricing', 'name' => ['en' => 'Pricing', 'ar' => 'الأسعار'], 'show_in_header' => true, 'sort_order' => 3],
            ['page_key' => 'how-it-works', 'name' => ['en' => 'How It Works', 'ar' => 'كيف يعمل'], 'show_in_header' => true, 'sort_order' => 4],
            ['page_key' => 'about', 'name' => ['en' => 'About Us', 'ar' => 'من نحن'], 'show_in_header' => true, 'sort_order' => 5],
            ['page_key' => 'contact', 'name' => ['en' => 'Contact', 'ar' => 'اتصل بنا'], 'show_in_header' => true, 'sort_order' => 6],
        ],
        'Restaurant & Food' => [
            ['page_key' => 'home', 'name' => ['en' => 'Home', 'ar' => 'الرئيسية'], 'show_in_header' => true, 'sort_order' => 1],
            ['page_key' => 'menu', 'name' => ['en' => 'Menu', 'ar' => 'قائمة الطعام'], 'show_in_header' => true, 'sort_order' => 2],
            ['page_key' => 'reservations', 'name' => ['en' => 'Reservations', 'ar' => 'الحجوزات'], 'show_in_header' => true, 'sort_order' => 3],
            ['page_key' => 'about', 'name' => ['en' => 'About Us', 'ar' => 'من نحن'], 'show_in_header' => true, 'sort_order' => 4],
            ['page_key' => 'gallery', 'name' => ['en' => 'Gallery', 'ar' => 'معرض الصور'], 'show_in_header' => true, 'sort_order' => 5],
            ['page_key' => 'contact', 'name' => ['en' => 'Contact', 'ar' => 'اتصل بنا'], 'show_in_header' => true, 'sort_order' => 6],
        ],
        'Salon & Spa' => [
            ['page_key' => 'home', 'name' => ['en' => 'Home', 'ar' => 'الرئيسية'], 'show_in_header' => true, 'sort_order' => 1],
            ['page_key' => 'services', 'name' => ['en' => 'Services', 'ar' => 'الخدمات'], 'show_in_header' => true, 'sort_order' => 2],
            ['page_key' => 'treatments', 'name' => ['en' => 'Treatments', 'ar' => 'العلاجات'], 'show_in_header' => true, 'sort_order' => 3],
            ['page_key' => 'booking', 'name' => ['en' => 'Book Appointment', 'ar' => 'حجز موعد'], 'show_in_header' => true, 'sort_order' => 4],
            ['page_key' => 'about', 'name' => ['en' => 'About Us', 'ar' => 'من نحن'], 'show_in_header' => true, 'sort_order' => 5],
            ['page_key' => 'contact', 'name' => ['en' => 'Contact', 'ar' => 'اتصل بنا'], 'show_in_header' => true, 'sort_order' => 6],
        ],
        'Healthcare & Medical' => [
            ['page_key' => 'home', 'name' => ['en' => 'Home', 'ar' => 'الرئيسية'], 'show_in_header' => true, 'sort_order' => 1],
            ['page_key' => 'services', 'name' => ['en' => 'Services', 'ar' => 'الخدمات'], 'show_in_header' => true, 'sort_order' => 2],
            ['page_key' => 'doctors', 'name' => ['en' => 'Our Doctors', 'ar' => 'أطباؤنا'], 'show_in_header' => true, 'sort_order' => 3],
            ['page_key' => 'appointments', 'name' => ['en' => 'Appointments', 'ar' => 'المواعيد'], 'show_in_header' => true, 'sort_order' => 4],
            ['page_key' => 'about', 'name' => ['en' => 'About Us', 'ar' => 'من نحن'], 'show_in_header' => true, 'sort_order' => 5],
            ['page_key' => 'contact', 'name' => ['en' => 'Contact', 'ar' => 'اتصل بنا'], 'show_in_header' => true, 'sort_order' => 6],
        ],
        'Fitness & Gym' => [
            ['page_key' => 'home', 'name' => ['en' => 'Home', 'ar' => 'الرئيسية'], 'show_in_header' => true, 'sort_order' => 1],
            ['page_key' => 'programs', 'name' => ['en' => 'Programs', 'ar' => 'البرامج'], 'show_in_header' => true, 'sort_order' => 2],
            ['page_key' => 'trainers', 'name' => ['en' => 'Trainers', 'ar' => 'المدربين'], 'show_in_header' => true, 'sort_order' => 3],
            ['page_key' => 'membership', 'name' => ['en' => 'Membership', 'ar' => 'العضوية'], 'show_in_header' => true, 'sort_order' => 4],
            ['page_key' => 'about', 'name' => ['en' => 'About Us', 'ar' => 'من نحن'], 'show_in_header' => true, 'sort_order' => 5],
            ['page_key' => 'contact', 'name' => ['en' => 'Contact', 'ar' => 'اتصل بنا'], 'show_in_header' => true, 'sort_order' => 6],
        ],
        'Real Estate' => [
            ['page_key' => 'home', 'name' => ['en' => 'Home', 'ar' => 'الرئيسية'], 'show_in_header' => true, 'sort_order' => 1],
            ['page_key' => 'properties', 'name' => ['en' => 'Properties', 'ar' => 'العقارات'], 'show_in_header' => true, 'sort_order' => 2],
            ['page_key' => 'agents', 'name' => ['en' => 'Our Agents', 'ar' => 'وكلاؤنا'], 'show_in_header' => true, 'sort_order' => 3],
            ['page_key' => 'services', 'name' => ['en' => 'Services', 'ar' => 'الخدمات'], 'show_in_header' => true, 'sort_order' => 4],
            ['page_key' => 'about', 'name' => ['en' => 'About Us', 'ar' => 'من نحن'], 'show_in_header' => true, 'sort_order' => 5],
            ['page_key' => 'contact', 'name' => ['en' => 'Contact', 'ar' => 'اتصل بنا'], 'show_in_header' => true, 'sort_order' => 6],
        ],
        'E-Commerce' => [
            ['page_key' => 'home', 'name' => ['en' => 'Home', 'ar' => 'الرئيسية'], 'show_in_header' => true, 'sort_order' => 1],
            ['page_key' => 'shop', 'name' => ['en' => 'Shop', 'ar' => 'المتجر'], 'show_in_header' => true, 'sort_order' => 2],
            ['page_key' => 'categories', 'name' => ['en' => 'Categories', 'ar' => 'الفئات'], 'show_in_header' => true, 'sort_order' => 3],
            ['page_key' => 'deals', 'name' => ['en' => 'Deals', 'ar' => 'العروض'], 'show_in_header' => true, 'sort_order' => 4],
            ['page_key' => 'about', 'name' => ['en' => 'About Us', 'ar' => 'من نحن'], 'show_in_header' => true, 'sort_order' => 5],
            ['page_key' => 'contact', 'name' => ['en' => 'Contact', 'ar' => 'اتصل بنا'], 'show_in_header' => true, 'sort_order' => 6],
        ],
        'Education & Training' => [
            ['page_key' => 'home', 'name' => ['en' => 'Home', 'ar' => 'الرئيسية'], 'show_in_header' => true, 'sort_order' => 1],
            ['page_key' => 'courses', 'name' => ['en' => 'Courses', 'ar' => 'الدورات'], 'show_in_header' => true, 'sort_order' => 2],
            ['page_key' => 'instructors', 'name' => ['en' => 'Instructors', 'ar' => 'المدربين'], 'show_in_header' => true, 'sort_order' => 3],
            ['page_key' => 'admissions', 'name' => ['en' => 'Admissions', 'ar' => 'القبول'], 'show_in_header' => true, 'sort_order' => 4],
            ['page_key' => 'about', 'name' => ['en' => 'About Us', 'ar' => 'من نحن'], 'show_in_header' => true, 'sort_order' => 5],
            ['page_key' => 'contact', 'name' => ['en' => 'Contact', 'ar' => 'اتصل بنا'], 'show_in_header' => true, 'sort_order' => 6],
        ],
        'Travel & Tourism' => [
            ['page_key' => 'home', 'name' => ['en' => 'Home', 'ar' => 'الرئيسية'], 'show_in_header' => true, 'sort_order' => 1],
            ['page_key' => 'destinations', 'name' => ['en' => 'Destinations', 'ar' => 'الوجهات'], 'show_in_header' => true, 'sort_order' => 2],
            ['page_key' => 'packages', 'name' => ['en' => 'Packages', 'ar' => 'الباقات'], 'show_in_header' => true, 'sort_order' => 3],
            ['page_key' => 'booking', 'name' => ['en' => 'Book Now', 'ar' => 'احجز الآن'], 'show_in_header' => true, 'sort_order' => 4],
            ['page_key' => 'about', 'name' => ['en' => 'About Us', 'ar' => 'من نحن'], 'show_in_header' => true, 'sort_order' => 5],
            ['page_key' => 'contact', 'name' => ['en' => 'Contact', 'ar' => 'اتصل بنا'], 'show_in_header' => true, 'sort_order' => 6],
        ],
        'Automotive' => [
            ['page_key' => 'home', 'name' => ['en' => 'Home', 'ar' => 'الرئيسية'], 'show_in_header' => true, 'sort_order' => 1],
            ['page_key' => 'inventory', 'name' => ['en' => 'Inventory', 'ar' => 'المخزون'], 'show_in_header' => true, 'sort_order' => 2],
            ['page_key' => 'services', 'name' => ['en' => 'Services', 'ar' => 'الخدمات'], 'show_in_header' => true, 'sort_order' => 3],
            ['page_key' => 'financing', 'name' => ['en' => 'Financing', 'ar' => 'التمويل'], 'show_in_header' => true, 'sort_order' => 4],
            ['page_key' => 'about', 'name' => ['en' => 'About Us', 'ar' => 'من نحن'], 'show_in_header' => true, 'sort_order' => 5],
            ['page_key' => 'contact', 'name' => ['en' => 'Contact', 'ar' => 'اتصل بنا'], 'show_in_header' => true, 'sort_order' => 6],
        ],
        'Photography & Media' => [
            ['page_key' => 'home', 'name' => ['en' => 'Home', 'ar' => 'الرئيسية'], 'show_in_header' => true, 'sort_order' => 1],
            ['page_key' => 'portfolio', 'name' => ['en' => 'Portfolio', 'ar' => 'أعمالنا'], 'show_in_header' => true, 'sort_order' => 2],
            ['page_key' => 'services', 'name' => ['en' => 'Services', 'ar' => 'الخدمات'], 'show_in_header' => true, 'sort_order' => 3],
            ['page_key' => 'pricing', 'name' => ['en' => 'Pricing', 'ar' => 'الأسعار'], 'show_in_header' => true, 'sort_order' => 4],
            ['page_key' => 'about', 'name' => ['en' => 'About Us', 'ar' => 'من نحن'], 'show_in_header' => true, 'sort_order' => 5],
            ['page_key' => 'contact', 'name' => ['en' => 'Contact', 'ar' => 'اتصل بنا'], 'show_in_header' => true, 'sort_order' => 6],
        ],
        'Event Management' => [
            ['page_key' => 'home', 'name' => ['en' => 'Home', 'ar' => 'الرئيسية'], 'show_in_header' => true, 'sort_order' => 1],
            ['page_key' => 'services', 'name' => ['en' => 'Services', 'ar' => 'الخدمات'], 'show_in_header' => true, 'sort_order' => 2],
            ['page_key' => 'events', 'name' => ['en' => 'Past Events', 'ar' => 'الفعاليات السابقة'], 'show_in_header' => true, 'sort_order' => 3],
            ['page_key' => 'packages', 'name' => ['en' => 'Packages', 'ar' => 'الباقات'], 'show_in_header' => true, 'sort_order' => 4],
            ['page_key' => 'about', 'name' => ['en' => 'About Us', 'ar' => 'من نحن'], 'show_in_header' => true, 'sort_order' => 5],
            ['page_key' => 'contact', 'name' => ['en' => 'Contact', 'ar' => 'اتصل بنا'], 'show_in_header' => true, 'sort_order' => 6],
        ],
        'Consulting & Professional Services' => [
            ['page_key' => 'home', 'name' => ['en' => 'Home', 'ar' => 'الرئيسية'], 'show_in_header' => true, 'sort_order' => 1],
            ['page_key' => 'services', 'name' => ['en' => 'Services', 'ar' => 'الخدمات'], 'show_in_header' => true, 'sort_order' => 2],
            ['page_key' => 'team', 'name' => ['en' => 'Our Team', 'ar' => 'فريقنا'], 'show_in_header' => true, 'sort_order' => 3],
            ['page_key' => 'case-studies', 'name' => ['en' => 'Case Studies', 'ar' => 'دراسات الحالة'], 'show_in_header' => true, 'sort_order' => 4],
            ['page_key' => 'about', 'name' => ['en' => 'About Us', 'ar' => 'من نحن'], 'show_in_header' => true, 'sort_order' => 5],
            ['page_key' => 'contact', 'name' => ['en' => 'Contact', 'ar' => 'اتصل بنا'], 'show_in_header' => true, 'sort_order' => 6],
        ],
        'Technology & IT' => [
            ['page_key' => 'home', 'name' => ['en' => 'Home', 'ar' => 'الرئيسية'], 'show_in_header' => true, 'sort_order' => 1],
            ['page_key' => 'services', 'name' => ['en' => 'Services', 'ar' => 'الخدمات'], 'show_in_header' => true, 'sort_order' => 2],
            ['page_key' => 'solutions', 'name' => ['en' => 'Solutions', 'ar' => 'الحلول'], 'show_in_header' => true, 'sort_order' => 3],
            ['page_key' => 'portfolio', 'name' => ['en' => 'Portfolio', 'ar' => 'أعمالنا'], 'show_in_header' => true, 'sort_order' => 4],
            ['page_key' => 'about', 'name' => ['en' => 'About Us', 'ar' => 'من نحن'], 'show_in_header' => true, 'sort_order' => 5],
            ['page_key' => 'contact', 'name' => ['en' => 'Contact', 'ar' => 'اتصل بنا'], 'show_in_header' => true, 'sort_order' => 6],
        ],
        'Retail & Shopping' => [
            ['page_key' => 'home', 'name' => ['en' => 'Home', 'ar' => 'الرئيسية'], 'show_in_header' => true, 'sort_order' => 1],
            ['page_key' => 'products', 'name' => ['en' => 'Products', 'ar' => 'المنتجات'], 'show_in_header' => true, 'sort_order' => 2],
            ['page_key' => 'collections', 'name' => ['en' => 'Collections', 'ar' => 'المجموعات'], 'show_in_header' => true, 'sort_order' => 3],
            ['page_key' => 'offers', 'name' => ['en' => 'Offers', 'ar' => 'العروض'], 'show_in_header' => true, 'sort_order' => 4],
            ['page_key' => 'about', 'name' => ['en' => 'About Us', 'ar' => 'من نحن'], 'show_in_header' => true, 'sort_order' => 5],
            ['page_key' => 'contact', 'name' => ['en' => 'Contact', 'ar' => 'اتصل بنا'], 'show_in_header' => true, 'sort_order' => 6],
        ],
    ];

    /**
     * Default pages for websites without category
     */
    protected array $defaultPages = [
        ['page_key' => 'home', 'name' => ['en' => 'Home', 'ar' => 'الرئيسية'], 'show_in_header' => true, 'sort_order' => 1],
        ['page_key' => 'services', 'name' => ['en' => 'Services', 'ar' => 'الخدمات'], 'show_in_header' => true, 'sort_order' => 2],
        ['page_key' => 'about', 'name' => ['en' => 'About Us', 'ar' => 'من نحن'], 'show_in_header' => true, 'sort_order' => 3],
        ['page_key' => 'contact', 'name' => ['en' => 'Contact', 'ar' => 'اتصل بنا'], 'show_in_header' => true, 'sort_order' => 4],
    ];

    /**
     * Get translated page name for a specific language
     *
     * @param array $pageConfig
     * @param string $langKey
     * @return string
     */
    protected function getPageName(array $pageConfig, string $langKey): string
    {
        // First try to get the name for the specific language
        if (isset($pageConfig['name'][$langKey])) {
            return $pageConfig['name'][$langKey];
        }

        // Fallback to English
        if (isset($pageConfig['name']['en'])) {
            return $pageConfig['name']['en'];
        }

        // Last resort - use page_key with capitalization
        return ucwords(str_replace(['-', '_'], ' ', $pageConfig['page_key']));
    }

    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Model::unguard();

        DB::table('website_page_translations')->delete();
        DB::table('website_pages')->delete();

        DB::statement('ALTER TABLE website_page_translations AUTO_INCREMENT = 1');
        DB::statement('ALTER TABLE website_pages AUTO_INCREMENT = 1');

        // Get all websites with their category
        $websites = DB::table('websites')
            ->leftJoin('website_categories', 'websites.website_category_id', '=', 'website_categories.id')
            ->select('websites.*', 'website_categories.name as category_name')
            ->get();

        $this->command->info("Found {$websites->count()} websites to process");

        foreach ($websites as $website) {
            // Get languages for this website
            $languages = DB::table('website_languages')
                ->where('website_id', $website->id)
                ->where('enabled', true)
                ->get();

            // If no languages found, skip this website
            if ($languages->isEmpty()) {
                $this->command->warn("No enabled languages found for website ID: {$website->id} - Skipping");
                continue;
            }

            $this->command->info("Processing website ID: {$website->id} (Category: " . ($website->category_name ?? 'Default') . ") with {$languages->count()} languages");

            // Get pages based on category or use default pages
            $pages = $this->getPagesForCategory($website->category_name);

            $this->command->info("  Found " . count($pages) . " pages to create for this website");

            foreach ($pages as $pageConfig) {
                // Create the website page
                $pageId = DB::table('website_pages')->insertGetId([
                    'company_id' => $website->company_id,
                    'website_id' => $website->id,
                    'page_key' => $pageConfig['page_key'],
                    'sort_order' => $pageConfig['sort_order'],
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);

                $this->command->info("  Created page: {$pageConfig['page_key']} (ID: {$pageId})");

                // Create translations for each language
                foreach ($languages as $language) {
                    // Get the translated name for this language
                    $pageName = $this->getPageName($pageConfig, $language->key);

                    DB::table('website_page_translations')->insert([
                        'website_page_id' => $pageId,
                        'website_language_id' => $language->id,
                        'name' => $pageName,
                        'show_in_header' => $pageConfig['show_in_header'],
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);

                    $this->command->info("    Translation added: {$language->key} => {$pageName}");
                }
            }
        }

        $totalPages = DB::table('website_pages')->count();
        $totalTranslations = DB::table('website_page_translations')->count();

        $this->command->info("\n" . str_repeat('=', 60));
        $this->command->info("Seeding completed successfully!");
        $this->command->info("Total pages created: {$totalPages}");
        $this->command->info("Total translations created: {$totalTranslations}");
        $this->command->info(str_repeat('=', 60));
    }

    /**
     * Get pages configuration for a category
     *
     * @param string|null $categoryName
     * @return array
     */
    protected function getPagesForCategory(?string $categoryName): array
    {
        if ($categoryName && isset($this->categoryPages[$categoryName])) {
            return $this->categoryPages[$categoryName];
        }

        return $this->defaultPages;
    }
}
