<?php

namespace Database\Seeders;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class WebsiteSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Model::unguard();

        DB::table('websites')->delete();

        DB::statement('ALTER TABLE websites AUTO_INCREMENT = 1');

        // Sample businesses with varied data (20 businesses)
        $businesses = [
            // Laundry & Dry Cleaning
            [
                'name' => 'SparkleWash',
                'slug' => 'sparklewash',
                'category' => 'Laundry & Dry Cleaning',
                'theme_name' => 'tailwind_theme',
                'theme_primary_color' => '#2563eb',
                'theme_secondary_color' => null,
                'theme_mode' => 'light',
                'is_favourite' => true,
                'custom_css' => '',
                'custom_js' => '',
            ],
            [
                'name' => 'Fresh & Clean Laundry',
                'slug' => 'fresh-clean-laundry',
                'category' => 'Laundry & Dry Cleaning',
                'theme_name' => 'tailwind_theme',
                'theme_primary_color' => '#10b981',
                'theme_secondary_color' => '#f59e0b',
                'theme_mode' => 'light',
                'is_favourite' => false,
                'custom_css' => '',
                'custom_js' => '',
            ],
            // Restaurant & Food
            [
                'name' => 'Urban Bites Restaurant',
                'slug' => 'urban-bites',
                'category' => 'Restaurant & Food',
                'theme_name' => 'tailwind_theme',
                'theme_primary_color' => '#ef4444',
                'theme_secondary_color' => '#f97316',
                'theme_mode' => 'light',
                'is_favourite' => true,
                'custom_css' => '',
                'custom_js' => '',
            ],
            [
                'name' => 'Savory Kitchen',
                'slug' => 'savory-kitchen',
                'category' => 'Restaurant & Food',
                'theme_name' => 'tailwind_theme',
                'theme_primary_color' => '#dc2626',
                'theme_secondary_color' => '#ea580c',
                'theme_mode' => 'light',
                'is_favourite' => false,
                'custom_css' => '',
                'custom_js' => '',
            ],
            // Salon & Spa
            [
                'name' => 'Serenity Spa & Wellness',
                'slug' => 'serenity-spa',
                'category' => 'Salon & Spa',
                'theme_name' => 'tailwind_theme',
                'theme_primary_color' => '#8b5cf6',
                'theme_secondary_color' => '#ec4899',
                'theme_mode' => 'light',
                'is_favourite' => false,
                'custom_css' => '',
                'custom_js' => '',
            ],
            [
                'name' => 'Glow Beauty Salon',
                'slug' => 'glow-beauty-salon',
                'category' => 'Salon & Spa',
                'theme_name' => 'tailwind_theme',
                'theme_primary_color' => '#d946ef',
                'theme_secondary_color' => '#f472b6',
                'theme_mode' => 'light',
                'is_favourite' => true,
                'custom_css' => '',
                'custom_js' => '',
            ],
            // Fitness & Gym
            [
                'name' => 'FitLife Gym',
                'slug' => 'fitlife-gym',
                'category' => 'Fitness & Gym',
                'theme_name' => 'tailwind_theme',
                'theme_primary_color' => '#f59e0b',
                'theme_secondary_color' => '#84cc16',
                'theme_mode' => 'light',
                'is_favourite' => true,
                'custom_css' => '',
                'custom_js' => '',
            ],
            [
                'name' => 'Iron Strength Fitness',
                'slug' => 'iron-strength-fitness',
                'category' => 'Fitness & Gym',
                'theme_name' => 'tailwind_theme',
                'theme_primary_color' => '#78716c',
                'theme_secondary_color' => '#fbbf24',
                'theme_mode' => 'light',
                'is_favourite' => false,
                'custom_css' => '',
                'custom_js' => '',
            ],
            // Technology & IT
            [
                'name' => 'Tech Solutions Pro',
                'slug' => 'tech-solutions-pro',
                'category' => 'Technology & IT',
                'theme_name' => 'tailwind_theme',
                'theme_primary_color' => '#0ea5e9',
                'theme_secondary_color' => '#6366f1',
                'theme_mode' => 'light',
                'is_favourite' => false,
                'custom_css' => '',
                'custom_js' => '',
            ],
            [
                'name' => 'Digital Innovators',
                'slug' => 'digital-innovators',
                'category' => 'Technology & IT',
                'theme_name' => 'tailwind_theme',
                'theme_primary_color' => '#3b82f6',
                'theme_secondary_color' => '#8b5cf6',
                'theme_mode' => 'light',
                'is_favourite' => true,
                'custom_css' => '',
                'custom_js' => '',
            ],
            // Real Estate
            [
                'name' => 'Dream Homes Realty',
                'slug' => 'dream-homes-realty',
                'category' => 'Real Estate',
                'theme_name' => 'tailwind_theme',
                'theme_primary_color' => '#059669',
                'theme_secondary_color' => '#0891b2',
                'theme_mode' => 'light',
                'is_favourite' => false,
                'custom_css' => '',
                'custom_js' => '',
            ],
            // Education & Training
            [
                'name' => 'Bright Minds Academy',
                'slug' => 'bright-minds-academy',
                'category' => 'Education & Training',
                'theme_name' => 'tailwind_theme',
                'theme_primary_color' => '#7c3aed',
                'theme_secondary_color' => '#2563eb',
                'theme_mode' => 'light',
                'is_favourite' => true,
                'custom_css' => '',
                'custom_js' => '',
            ],
            [
                'name' => 'LearnHub Online',
                'slug' => 'learnhub-online',
                'category' => 'Education & Training',
                'theme_name' => 'tailwind_theme',
                'theme_primary_color' => '#4f46e5',
                'theme_secondary_color' => '#06b6d4',
                'theme_mode' => 'light',
                'is_favourite' => false,
                'custom_css' => '',
                'custom_js' => '',
            ],
            // Healthcare & Medical
            [
                'name' => 'HealthFirst Clinic',
                'slug' => 'healthfirst-clinic',
                'category' => 'Healthcare & Medical',
                'theme_name' => 'tailwind_theme',
                'theme_primary_color' => '#0d9488',
                'theme_secondary_color' => '#22c55e',
                'theme_mode' => 'light',
                'is_favourite' => true,
                'custom_css' => '',
                'custom_js' => '',
            ],
            [
                'name' => 'CarePlus Medical Center',
                'slug' => 'careplus-medical',
                'category' => 'Healthcare & Medical',
                'theme_name' => 'tailwind_theme',
                'theme_primary_color' => '#14b8a6',
                'theme_secondary_color' => '#3b82f6',
                'theme_mode' => 'light',
                'is_favourite' => false,
                'custom_css' => '',
                'custom_js' => '',
            ],
            // Travel & Tourism
            [
                'name' => 'Wanderlust Travel Agency',
                'slug' => 'wanderlust-travel',
                'category' => 'Travel & Tourism',
                'theme_name' => 'tailwind_theme',
                'theme_primary_color' => '#0284c7',
                'theme_secondary_color' => '#f97316',
                'theme_mode' => 'light',
                'is_favourite' => true,
                'custom_css' => '',
                'custom_js' => '',
            ],
            // Automotive
            [
                'name' => 'AutoCare Pro',
                'slug' => 'autocare-pro',
                'category' => 'Automotive',
                'theme_name' => 'tailwind_theme',
                'theme_primary_color' => '#64748b',
                'theme_secondary_color' => '#ef4444',
                'theme_mode' => 'light',
                'is_favourite' => false,
                'custom_css' => '',
                'custom_js' => '',
            ],
            // E-Commerce
            [
                'name' => 'ShopEase Online Store',
                'slug' => 'shopease-online',
                'category' => 'E-Commerce',
                'theme_name' => 'tailwind_theme',
                'theme_primary_color' => '#f59e0b',
                'theme_secondary_color' => '#10b981',
                'theme_mode' => 'light',
                'is_favourite' => true,
                'custom_css' => '',
                'custom_js' => '',
            ],
            // Photography & Media
            [
                'name' => 'Capture Moments Studio',
                'slug' => 'capture-moments-studio',
                'category' => 'Photography & Media',
                'theme_name' => 'tailwind_theme',
                'theme_primary_color' => '#1e293b',
                'theme_secondary_color' => '#fbbf24',
                'theme_mode' => 'light',
                'is_favourite' => false,
                'custom_css' => '',
                'custom_js' => '',
            ],
            // Event Management
            [
                'name' => 'Elite Events Co',
                'slug' => 'elite-events',
                'category' => 'Event Management',
                'theme_name' => 'tailwind_theme',
                'theme_primary_color' => '#c026d3',
                'theme_secondary_color' => '#f472b6',
                'theme_mode' => 'light',
                'is_favourite' => true,
                'custom_css' => '',
                'custom_js' => '',
            ],
        ];

        // Create businesses for each company
        $companies = DB::table('companies')->get();

        foreach ($companies as $company) {
            // Get English language for this company
            $englishLang = DB::table('website_languages')
                ->where('company_id', $company->id)
                ->where('key', 'en')
                ->first();

            // Get categories for this company
            $categoriesRaw = DB::table('website_categories')->where('company_id', $company->id)->get();
            $categories = [];
            foreach ($categoriesRaw as $cat) {
                $categories[$cat->name] = $cat;
            }

            foreach ($businesses as $businessData) {
                $categoryId = null;
                if (isset($categories[$businessData['category']])) {
                    $categoryId = $categories[$businessData['category']]->id;
                }

                DB::table('websites')->insert([
                    'company_id' => $company->id,
                    'website_category_id' => $categoryId,
                    'name' => $businessData['name'],
                    'slug' => $businessData['slug'],
                    'theme_name' => $businessData['theme_name'],
                    'theme_primary_color' => $businessData['theme_primary_color'],
                    'theme_secondary_color' => $businessData['theme_secondary_color'],
                    'theme_mode' => $businessData['theme_mode'],
                    'is_favourite' => $businessData['is_favourite'],
                    'is_primary' => false,
                    'custom_css' => $businessData['custom_css'],
                    'custom_js' => $businessData['custom_js'],
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
            }
        }
    }
}
