import Antd, * as AntdExports from "ant-design-vue";
import "ant-design-vue/dist/reset.css";

export default (app) => {
    // Register all Ant Design components globally
    app.use(Antd);

    // Make message and Modal available globally
    app.config.globalProperties.$message = Antd.message;
    app.config.globalProperties.$modal = Antd.Modal;

    // Expose all Ant Design Vue for modules (both default export and named exports)
    // This allows modules to use: import { message } from "ant-design-vue"
    window['ant-design-vue'] = {
        ...AntdExports,
        default: Antd
    };

    // Also expose message and modal directly for convenience
    window.$message = Antd.message;
    window.$modal = Antd.Modal;
};
